/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.codec.w3c;

import com.google.common.net.MediaType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.ErrorCodec;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.codec.AbstractHttpResponseCodec;
import org.openqa.selenium.remote.http.HttpResponse;

public class W3CHttpResponseCodec
extends AbstractHttpResponseCodec {
    private static final Logger LOG = Logger.getLogger(W3CHttpResponseCodec.class.getName());
    private final ErrorCodec errorCodec = ErrorCodec.createDefault();
    private final ErrorCodes errorCodes = new ErrorCodes();
    private final Json json = new Json();
    private final Function<Object, Object> elementConverter = new JsonToWebElementConverter(null);

    @Override
    public Response decode(HttpResponse encodedResponse) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Decoding response (status was: {0}, content type: {1}, content length: {2})", new Object[]{encodedResponse.getStatus(), encodedResponse.getContentType(), encodedResponse.getContentLength()});
        }
        String contentType = Objects.requireNonNullElse(encodedResponse.getContentType(), "");
        Response response = new Response();
        if (!encodedResponse.isSuccessful()) {
            LOG.fine("Processing an error");
            String content = encodedResponse.contentAsString().trim();
            if (405 == encodedResponse.getStatus()) {
                response.setState("unknown command");
                response.setStatus(9);
                response.setValue(content);
            } else if (504 == encodedResponse.getStatus() || 502 == encodedResponse.getStatus()) {
                response.setState("unknown error");
                response.setStatus(13);
                response.setValue(content);
            } else {
                Map org = (Map)this.json.toType(content, Json.MAP_TYPE);
                Object w3cWrappedValue = org.get("value");
                Map obj = w3cWrappedValue instanceof Map && ((Map)w3cWrappedValue).containsKey("error") ? (Map)w3cWrappedValue : org;
                String message = "An unknown error has occurred";
                if (obj.get("message") instanceof String) {
                    message = (String)obj.get("message");
                }
                String error = "unknown error";
                if (obj.get("error") instanceof String) {
                    error = (String)obj.get("error");
                }
                response.setState(error);
                response.setStatus(this.errorCodes.toStatus(error, Optional.of(encodedResponse.getStatus())));
                if ("unexpected alert open".equals(error) && 500 == encodedResponse.getStatus()) {
                    Object rawText;
                    String text = "";
                    Object data = obj.get("data");
                    if (data != null && (rawText = ((Map)data).get("text")) instanceof String) {
                        text = (String)rawText;
                    }
                    response.setValue(new UnhandledAlertException(message, text));
                } else {
                    response.setValue((Object)this.errorCodec.decode(org));
                }
            }
            return response;
        }
        response.setState("success");
        response.setStatus(0);
        if (contentType.startsWith(MediaType.OCTET_STREAM.toString())) {
            response.setValue(encodedResponse.getContent());
            return response;
        }
        String content = encodedResponse.contentAsString().trim();
        if (!content.isEmpty() && contentType.startsWith("application/json")) {
            Map parsed = (Map)this.json.toType(content, Json.MAP_TYPE);
            if (parsed.containsKey("value")) {
                Object value = parsed.get("value");
                response.setValue(value);
            } else {
                response.setValue(this.json.toType(content, Json.OBJECT_TYPE));
            }
        }
        if (response.getValue() instanceof String) {
            response.setValue(((String)response.getValue()).replace("\r\n", "\n"));
        }
        return response;
    }

    @Override
    protected Object getValueToEncode(Response response) {
        Map<String, Object> value = response.getValue();
        if (value instanceof WebDriverException) {
            value = this.errorCodec.encode((WebDriverException)((Object)value));
        }
        return Map.of("value", value);
    }

    @Override
    protected Response reconstructValue(Response response) {
        response.setValue(this.elementConverter.apply(response.getValue()));
        return response;
    }
}

