/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.internal.seleniumemulation.AlertOverride;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

public class ClickAt
extends SeleneseCommand<Void> {
    private final AlertOverride alertOverride;
    private final ElementFinder finder;

    public ClickAt(AlertOverride alertOverride, ElementFinder elementFinder) {
        this.alertOverride = alertOverride;
        this.finder = elementFinder;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String locator, String value) {
        this.alertOverride.replaceAlertMethod(driver);
        WebElement element = this.finder.findElement(driver, locator);
        String[] parts = value.split(",");
        int xOffset = Integer.parseInt(parts[0]);
        int yOffset = Integer.parseInt(parts[1]);
        new Actions(driver).moveToElement(element, xOffset, yOffset).click().perform();
        return null;
    }
}

