/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.base.Throwables;
import com.thoughtworks.selenium.Wait;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitForPageToLoad
extends SeleneseCommand<Void> {
    Logger log = Logger.getLogger(WaitForPageToLoad.class.getName());
    private int timeToWait = 250;

    public void setTimeToWait(int timeToWait) {
        this.timeToWait = timeToWait;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String timeout, String ignored) {
        Object result;
        if (!(driver instanceof JavascriptExecutor)) {
            return null;
        }
        long timeoutInMillis = Long.parseLong(timeout);
        this.hesitate(this.timeToWait);
        try {
            result = ((JavascriptExecutor)driver).executeScript("return !!document['readyState'];", new Object[0]);
        }
        catch (WebDriverException e) {
            this.hesitate(500L);
            try {
                result = ((JavascriptExecutor)driver).executeScript("return !!document['readyState'];", new Object[0]);
            }
            catch (WebDriverException e2) {
                this.log.warning("Cannot determine whether page supports ready state. Abandoning wait.");
                return null;
            }
        }
        this.log.fine("Does browser support readyState: " + result);
        Wait wait = result != null && (Boolean)result != false ? this.getReadyStateUsingWait(driver) : this.getLengthCheckingWait(driver);
        wait.wait(String.format("Failed to load page within %s ms", timeout), timeoutInMillis);
        this.hesitate(this.timeToWait);
        return null;
    }

    private void hesitate(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Wait getReadyStateUsingWait(final WebDriver driver) {
        return new Wait(){

            public boolean until() {
                try {
                    Object result = ((JavascriptExecutor)driver).executeScript("return 'complete' == document.readyState;", new Object[0]);
                    if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        };
    }

    public Wait getLengthCheckingWait(final WebDriver driver) {
        return new Wait(){
            private int length;
            private long seenAt;

            public boolean until() {
                try {
                    int currentLength = driver.findElement(By.tagName((String)"body")).getText().length();
                    if (this.seenAt == 0L) {
                        this.seenAt = System.currentTimeMillis();
                        this.length = currentLength;
                        return false;
                    }
                    if (currentLength != this.length) {
                        this.seenAt = System.currentTimeMillis();
                        this.length = currentLength;
                        return false;
                    }
                    return System.currentTimeMillis() - this.seenAt > 1000L;
                }
                catch (NoSuchElementException ignored) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                return false;
            }
        };
    }
}

