/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerLogs;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class GetContainerLogs {
    private static final Logger LOG = Logger.getLogger(GetContainerLogs.class.getName());
    private final HttpHandler client;
    private final String apiVersion;

    public GetContainerLogs(HttpHandler client, String apiVersion) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
        this.apiVersion = (String)Require.nonNull((String)"API version", (Object)apiVersion);
    }

    public ContainerLogs apply(ContainerId id) {
        Require.nonNull((String)"Container id", (Object)id);
        String requestUrl = String.format("/v%s/containers/%s/logs?stdout=true&stderr=true", this.apiVersion, id);
        HttpResponse res = this.client.execute((HttpRequest)new HttpRequest(HttpMethod.GET, requestUrl).addHeader("Content-Type", "text/plain"));
        if (res.getStatus() != 200) {
            LOG.warning("Unable to inspect container " + String.valueOf(id));
        }
        List<String> logLines = List.of(Contents.string((HttpMessage)res).split("\n"));
        return new ContainerLogs(id, logLines);
    }
}

