/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxDriverLogLevel;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class GeckoDriverService
extends FirefoxDriverService {
    public static final String GECKO_DRIVER_NAME = "geckodriver";
    public static final String GECKO_DRIVER_EXE_PROPERTY = "webdriver.gecko.driver";
    public static final String GECKO_DRIVER_EXE_ENVIRONMENT_VARIABLE = "SE_GECKODRIVER";
    public static final String GECKO_DRIVER_LOG_PROPERTY = "webdriver.firefox.logfile";
    public static final String GECKO_DRIVER_LOG_LEVEL_PROPERTY = "webdriver.firefox.logLevel";
    public static final String GECKO_DRIVER_LOG_NO_TRUNCATE = "webdriver.firefox.logTruncate";
    public static final String GECKO_DRIVER_PROFILE_ROOT = "webdriver.firefox.profileRoot";

    public GeckoDriverService(@Nullable File executable, int port, @Nullable Duration timeout, @Nullable List<String> args, @Nullable Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public String getDriverName() {
        return GECKO_DRIVER_NAME;
    }

    public String getDriverProperty() {
        return GECKO_DRIVER_EXE_PROPERTY;
    }

    public String getDriverEnvironmentVariable() {
        return GECKO_DRIVER_EXE_ENVIRONMENT_VARIABLE;
    }

    public Capabilities getDefaultDriverOptions() {
        return new FirefoxOptions();
    }

    public static GeckoDriverService createDefaultService() {
        return (GeckoDriverService)new Builder().build();
    }

    protected void waitUntilAvailable() {
        PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)((int)this.getTimeout().toMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected boolean hasShutdownEndpoint() {
        return false;
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends FirefoxDriverService.Builder<GeckoDriverService, Builder> {
        private @Nullable String allowHosts;
        private @Nullable FirefoxDriverLogLevel logLevel;
        private @Nullable Boolean logTruncate;
        private @Nullable File profileRoot;
        private @Nullable Integer marionettePort;
        private @Nullable Integer websocketPort;

        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.FIREFOX.is(capabilities)) {
                ++score;
            }
            if (capabilities.getCapability("moz:firefoxOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAllowHosts(@Nullable String allowHosts) {
            this.allowHosts = allowHosts;
            return this;
        }

        public Builder withLogLevel(@Nullable FirefoxDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withTruncatedLogs(@Nullable Boolean truncate) {
            this.logTruncate = truncate;
            return this;
        }

        public Builder withProfileRoot(@Nullable File root) {
            this.profileRoot = root;
            return this;
        }

        public Builder connectToExisting(int marionettePort) {
            this.marionettePort = marionettePort;
            return this;
        }

        public Builder withWebSocketPort(@Nullable Integer websocketPort) {
            this.websocketPort = websocketPort;
            return this;
        }

        protected void loadSystemProperties() {
            String profileRootFromProperty;
            this.parseLogOutput(GeckoDriverService.GECKO_DRIVER_LOG_PROPERTY);
            if (Debug.isDebugAll()) {
                this.logLevel = FirefoxDriverLogLevel.DEBUG;
            } else if (this.logLevel == null) {
                this.logLevel = FirefoxDriverLogLevel.fromString(System.getProperty(GeckoDriverService.GECKO_DRIVER_LOG_LEVEL_PROPERTY));
            }
            if (this.logTruncate == null) {
                this.logTruncate = !Boolean.getBoolean(GeckoDriverService.GECKO_DRIVER_LOG_NO_TRUNCATE);
            }
            if (this.profileRoot == null && (profileRootFromProperty = System.getProperty(GeckoDriverService.GECKO_DRIVER_PROFILE_ROOT)) != null) {
                this.profileRoot = new File(profileRootFromProperty);
            }
        }

        protected List<String> createArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format(Locale.ROOT, "--port=%d", this.getPort()));
            if (this.marionettePort != null) {
                args.add("--connect-existing");
                args.add("--marionette-port");
                args.add(String.valueOf(this.marionettePort));
            } else if (this.websocketPort != null) {
                args.add("--websocket-port");
                args.add(String.valueOf(this.websocketPort));
                args.add("--allow-origins");
                args.add(String.format("http://127.0.0.1:%d", this.websocketPort));
                args.add(String.format("http://localhost:%d", this.websocketPort));
                args.add(String.format("http://[::1]:%d", this.websocketPort));
            } else {
                args.add("--websocket-port");
                args.add("0");
            }
            if (this.logLevel != null) {
                args.add("--log");
                args.add(this.logLevel.toString());
            }
            if (this.logTruncate != null && this.logTruncate.equals(Boolean.FALSE)) {
                args.add("--log-no-truncate");
            }
            if (this.profileRoot != null) {
                args.add("--profile-root");
                args.add(this.profileRoot.getAbsolutePath());
            }
            if (this.allowHosts != null) {
                args.add("--allow-hosts");
                args.addAll(List.of(this.allowHosts.split(" ")));
            }
            return Collections.unmodifiableList(args);
        }

        protected GeckoDriverService createDriverService(@Nullable File exe, int port, @Nullable Duration timeout, @Nullable List<String> args, @Nullable Map<String, String> environment) {
            try {
                return new GeckoDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

