/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractTab;
import org.richfaces.component.AbstractTabPanel;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.AbstractTogglePanelItemInterface;
import org.richfaces.component.AbstractTogglePanelTitledItem;
import org.richfaces.component.TogglePanelVisitCallback;
import org.richfaces.component.TogglePanelVisitState;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.TogglePanelRenderer;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="togglePanel.js"), @ResourceDependency(library="org.richfaces", name="tabPanel.js"), @ResourceDependency(library="org.richfaces", name="tabPanel.ecss")})
public class TabPanelRenderer
extends TogglePanelRenderer {
    private static final RenderKitUtils.Attributes HEADER_ATTRIBUTES = RenderKitUtils.attributes().generic("onclick", "onheaderclick", "headerclick").generic("ondblclick", "onheaderdblclick", "headerdblclick").generic("onmousedown", "onheadermousedown", "headermousedown").generic("onmousemove", "onheadermousemove", "headermousemove").generic("onmouseup", "onheadermouseup", "headermouseup");
    private static final String DIV = "div";
    private static final String STYLE = "style";
    private static final String CLASS = "class";

    @Override
    protected boolean isSubmitted(FacesContext context, AbstractTogglePanel panel) {
        String activePanelName = panel.getSubmittedActiveItem();
        String clientId = panel.getClientIdByName(activePanelName);
        if (clientId == null) {
            return false;
        }
        Map parameterMap = context.getExternalContext().getRequestParameterMap();
        return parameterMap.get(clientId) != null;
    }

    @Override
    protected void doEncodeBegin(ResponseWriter w, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeBegin(w, context, component);
        AbstractTabPanel tabPanel = (AbstractTabPanel)component;
        if (tabPanel.isHeaderPositionedTop()) {
            this.writeTabsLine(w, context, component);
            this.writeTabsLineSeparator(w, component);
        }
    }

    private void writeTabsLineSeparator(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)"rf-tab-hdr-brd", null);
        writer.endElement(DIV);
    }

    private void writeTabsLine(ResponseWriter w, FacesContext context, UIComponent comp) throws IOException {
        w.startElement(DIV, comp);
        AbstractTabPanel tabPanel = (AbstractTabPanel)comp;
        if (tabPanel.isHeaderPositionedTop()) {
            w.writeAttribute(CLASS, (Object)"rf-tab-hdr-tabline-vis rf-tab-hdr-tabline-top", null);
        } else {
            w.writeAttribute(CLASS, (Object)"rf-tab-hdr-tabline-vis rf-tab-hdr-tabline-btm", null);
        }
        w.startElement("table", comp);
        w.writeAttribute(CLASS, (Object)"rf-tab-hdr-tabs", null);
        w.writeAttribute("cellspacing", (Object)"0", null);
        w.startElement("tbody", comp);
        w.startElement("tr", comp);
        this.writeTopTabFirstSpacer(w, comp);
        this.writeTabLine(w, context, tabPanel);
        this.writeTopTabLastSpacer(w, comp);
        w.endElement("tr");
        w.endElement("tbody");
        w.endElement("table");
        this.writeTopTabsControl(w, comp, "rf-tab-hdr-scrl-lft rf-tab-hdn", "\u00ab");
        this.writeTopTabsControl(w, comp, "rf-tab-hdr-tablst rf-tab-hdn", "\u2193");
        this.writeTopTabsControl(w, comp, "rf-tab-hdr-scrl-rgh rf-tab-hdn", "\u00bb");
        w.endElement(DIV);
    }

    private void writeTabLine(final ResponseWriter w, FacesContext context, final AbstractTabPanel panel) throws IOException {
        panel.visitTogglePanelItems(panel, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext context, TogglePanelVisitState visitState) {
                AbstractTogglePanelItemInterface item = visitState.getItem();
                if (item.isRendered() && item instanceof AbstractTab) {
                    try {
                        AbstractTab tab = (AbstractTab)item;
                        TabPanelRenderer.this.writeTopTabHeader(context, w, tab);
                        TabPanelRenderer.this.writeTopTabSpacer(w, (UIComponent)panel);
                    }
                    catch (IOException e) {
                        throw new FacesException((Throwable)e);
                    }
                }
                return VisitResult.ACCEPT;
            }
        });
    }

    @Override
    protected String getStyle(UIComponent component) {
        return TabPanelRenderer.attributeAsString(component, STYLE);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return HtmlUtil.concatClasses("rf-tbp", TabPanelRenderer.attributeAsString(component, "styleClass"));
    }

    private void writeTopTabHeader(FacesContext context, ResponseWriter writer, AbstractTab tab) throws IOException {
        boolean isActive = tab.isActive();
        boolean isDisabled = tab.isDisabled();
        this.encodeTabHeader(context, tab, writer, AbstractTogglePanelTitledItem.HeaderStates.inactive, !isActive && !isDisabled);
        this.encodeTabHeader(context, tab, writer, AbstractTogglePanelTitledItem.HeaderStates.active, isActive && !isDisabled);
        this.encodeTabHeader(context, tab, writer, AbstractTogglePanelTitledItem.HeaderStates.disabled, isDisabled);
    }

    private String positionAbbreviation(AbstractTab tab) {
        if (tab.getParentPanel().isHeaderPositionedTop()) {
            return "top";
        }
        return "btm";
    }

    private void encodeTabHeader(FacesContext context, AbstractTab tab, ResponseWriter writer, AbstractTogglePanelTitledItem.HeaderStates state, Boolean isDisplay) throws IOException {
        String headerStateClass = "rf-tab-hdr-" + state.abbreviation();
        String headerPositionClass = "rf-tab-hdr-" + this.positionAbbreviation(tab);
        writer.startElement("td", (UIComponent)tab);
        writer.writeAttribute("id", (Object)(tab.getClientId(context) + ":header:" + state.toString()), null);
        RenderKitUtils.renderPassThroughAttributes(context, (UIComponent)tab, HEADER_ATTRIBUTES);
        writer.writeAttribute(CLASS, (Object)this.concatClasses("rf-tab-hdr", headerStateClass, headerPositionClass, TabPanelRenderer.attributeAsString((UIComponent)tab, "headerClass"), TabPanelRenderer.attributeAsString((UIComponent)tab, state.headerClass())), null);
        writer.writeAttribute(STYLE, (Object)this.concatStyles(isDisplay != false ? "" : "display : none", TabPanelRenderer.attributeAsString((UIComponent)tab, "headerStyle")), null);
        writer.startElement("span", (UIComponent)tab);
        writer.writeAttribute(CLASS, (Object)"rf-tab-lbl", null);
        UIComponent headerFacet = tab.getHeaderFacet(state);
        if (headerFacet != null && headerFacet.isRendered()) {
            headerFacet.encodeAll(context);
        } else {
            Object headerText = tab.getAttributes().get("header");
            if (headerText != null && !headerText.equals("")) {
                writer.writeText(headerText, null);
            }
        }
        writer.endElement("span");
        writer.endElement("td");
    }

    private void writeTopTabsControl(ResponseWriter w, UIComponent comp, String styles, String text) throws IOException {
        w.startElement(DIV, comp);
        w.writeAttribute(CLASS, (Object)styles, null);
        w.writeText((Object)text, null);
        w.endElement(DIV);
    }

    private void writeTopTabFirstSpacer(ResponseWriter w, UIComponent comp) throws IOException {
        AbstractTabPanel tabPanel = (AbstractTabPanel)comp;
        if (tabPanel.isHeaderAlignedLeft()) {
            this.writeTopTabSpacer(w, comp, "padding-left: 5px;", "rf-tab-hdr-spcr");
        } else {
            this.writeTopTabSpacer(w, comp, "padding-left: 5px; width:100%", "rf-tab-hdr-spcr");
        }
    }

    private void writeTopTabSpacer(ResponseWriter w, UIComponent comp) throws IOException {
        this.writeTopTabSpacer(w, comp, "", "rf-tab-hdr-spcr rf-tab-hortab-tabspcr-wdh");
    }

    private void writeTopTabLastSpacer(ResponseWriter w, UIComponent comp) throws IOException {
        AbstractTabPanel tabPanel = (AbstractTabPanel)comp;
        if (tabPanel.isHeaderAlignedLeft()) {
            this.writeTopTabSpacer(w, comp, "padding-right: 5px; width: 100%;", "rf-tab-hdr-spcr");
        } else {
            this.writeTopTabSpacer(w, comp, "padding-right: 5px;", "rf-tab-hdr-spcr");
        }
    }

    private void writeTopTabSpacer(ResponseWriter w, UIComponent comp, String style, String styleClass) throws IOException {
        w.startElement("td", comp);
        w.writeAttribute(STYLE, (Object)style, null);
        w.writeAttribute(CLASS, (Object)styleClass, null);
        w.write("<br />");
        w.endElement("td");
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractTabPanel panel = (AbstractTabPanel)component;
        if (!panel.isHeaderPositionedTop()) {
            this.writeTabsLineSeparator(writer, component);
            this.writeTabsLine(writer, context, component);
        }
        writer.endElement(DIV);
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TabPanel", new Object[]{component.getClientId(context), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        Map<String, Object> options = super.getScriptObjectOptions(context, component);
        options.put("isKeepHeight", TabPanelRenderer.attributeAsString(component, "height").length() > 0);
        return options;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTabPanel.class;
    }
}

