/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UIPopupPanel;

@ResourceDependencies(value={@ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="script/popupPanel.js"), @ResourceDependency(name="script/popupPanelBorders.js"), @ResourceDependency(name="script/popupPanelSizer.js"), @ResourceDependency(name="css/popupPanel.ecss")})
public class PopupPanelBaseRenderer
extends RendererBase {
    private static final String CONTROLS_FACET = "controls";
    private static final String HEADER_FACET = "header";
    private static final int SIZE = 10;
    private static final String STATE_OPTION_SUFFIX = "StateOption_";
    private static final Set<String> ALLOWED_ATTACHMENT_OPTIONS = new HashSet<String>();

    public void renderHeaderFacet(FacesContext context, UIComponent component) throws IOException {
        this.renderFacet(context, component, HEADER_FACET);
    }

    public void renderControlsFacet(FacesContext context, UIComponent component) throws IOException {
        this.renderFacet(context, component, CONTROLS_FACET);
    }

    private void renderFacet(FacesContext context, UIComponent component, String facet) throws IOException {
        UIComponent headerFacet = component.getFacet(facet);
        headerFacet.encodeAll(context);
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        UIPopupPanel panel = (UIPopupPanel)component;
        ExternalContext exCtx = context.getExternalContext();
        Map rqMap = exCtx.getRequestParameterMap();
        Object panelOpenState = rqMap.get(panel.getClientId(context) + "OpenedState");
        if (panel.isKeepVisualState() && null != panelOpenState) {
            boolean show = panel.isShow() || Boolean.parseBoolean((String)panelOpenState);
            panel.setShow(show);
            Map<String, Object> visualOptions = panel.getHandledVisualOptions();
            for (Map.Entry entry : rqMap.entrySet()) {
                int suffixPos = ((String)entry.getKey()).toString().indexOf(STATE_OPTION_SUFFIX);
                if (-1 == suffixPos) continue;
                String key = ((String)entry.getKey()).toString().substring(suffixPos + STATE_OPTION_SUFFIX.length());
                visualOptions.put(key, entry.getValue());
            }
        }
    }

    protected Class getComponentClass() {
        return UIPopupPanel.class;
    }

    public void checkOptions(FacesContext context, UIComponent component) {
        UIPopupPanel panel = (UIPopupPanel)component;
        if (panel.isAutosized() && panel.isResizeable()) {
            throw new IllegalArgumentException("Autosized modal panel can't be resizeable.");
        }
        String domElementAttachment = panel.getDomElementAttachment();
        if (domElementAttachment != null && domElementAttachment.trim().length() != 0 && !ALLOWED_ATTACHMENT_OPTIONS.contains(domElementAttachment)) {
            throw new IllegalArgumentException("Value '" + domElementAttachment + "' of domElementAttachment attribute is illegal. " + "Allowed values are: " + ALLOWED_ATTACHMENT_OPTIONS);
        }
        if (panel.getMinHeight() != -1 && panel.getMinHeight() < 10) {
            throw new IllegalArgumentException();
        }
        if (panel.getMinWidth() != -1 && panel.getMinWidth() < 10) {
            throw new IllegalArgumentException();
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String buildShowScript(FacesContext context, UIComponent component) {
        UIPopupPanel panel = (UIPopupPanel)component;
        StringBuilder result = new StringBuilder();
        if (panel.isShow()) {
            result.append("RichFaces.ui.PopupPanel.showPopupPanel('" + panel.getClientId(context) + "', {");
            Iterator<Map.Entry<String, Object>> it = panel.getHandledVisualOptions().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                result.append(entry.getKey() + ": '" + entry.getValue() + "'");
                if (!it.hasNext()) continue;
                result.append(", ");
            }
            result.append("});");
        }
        return result.toString();
    }

    public String getStyleIfTrimmed(UIComponent panel) {
        if (panel.getAttributes().get("trimOverlayedElements").equals(Boolean.TRUE)) {
            return "position: relative, z-index : 0";
        }
        return "";
    }

    private void writeOption(StringBuilder builder, String attribbute, Object value, UIComponent component, boolean isString) {
        if (component.getAttributes().get(attribbute) != null) {
            builder.append(attribbute + ":");
            if (isString) {
                builder.append("'");
            }
            builder.append(value);
            if (isString) {
                builder.append("'");
            }
            builder.append(",");
        }
    }

    public String buildScript(FacesContext context, UIComponent component) throws IOException {
        UIPopupPanel panel = (UIPopupPanel)component;
        StringBuilder result = new StringBuilder();
        result.append("new RichFaces.ui.PopupPanel('");
        result.append(panel.getClientId());
        result.append("',{");
        this.writeOption(result, "width", panel.getWidth(), component, false);
        this.writeOption(result, "height", panel.getHeight(), component, false);
        this.writeOption(result, "minWidth", panel.getMinWidth(), component, false);
        this.writeOption(result, "minHeight", panel.getMinHeight(), component, false);
        this.writeOption(result, "maxWidth", panel.getMaxWidth(), component, false);
        this.writeOption(result, "maxHeight", panel.getMaxHeight(), component, false);
        this.writeOption(result, "resizeable", panel.isResizeable(), component, false);
        this.writeOption(result, "moveable", panel.isMoveable(), component, false);
        this.writeOption(result, "left", panel.getLeft(), component, true);
        this.writeOption(result, "top", panel.getTop(), component, true);
        this.writeOption(result, "zIndex", panel.getZIndex(), component, false);
        this.writeOption(result, "onresize", this.writeEventHandlerFunction(context, (UIComponent)panel, "onresize"), component, false);
        this.writeOption(result, "onmove", this.writeEventHandlerFunction(context, (UIComponent)panel, "onmove"), component, false);
        this.writeOption(result, "onshow", this.writeEventHandlerFunction(context, (UIComponent)panel, "onshow"), component, false);
        this.writeOption(result, "onhide", this.writeEventHandlerFunction(context, (UIComponent)panel, "onhide"), component, false);
        this.writeOption(result, "onbeforeshow", this.writeEventHandlerFunction(context, (UIComponent)panel, "onbeforeshow"), component, false);
        this.writeOption(result, "onbeforehide", this.writeEventHandlerFunction(context, (UIComponent)panel, "onbeforehide"), component, false);
        this.writeOption(result, "shadowDepth", panel.getShadowDepth(), component, true);
        this.writeOption(result, "shadowOpacity", panel.getShadowOpacity(), component, true);
        this.writeOption(result, "domElementAttachment", panel.getDomElementAttachment(), component, true);
        this.writeOption(result, "keepVisualState", panel.isKeepVisualState(), component, false);
        this.writeOption(result, "show", panel.isShow(), component, false);
        this.writeOption(result, "autosized", panel.isAutosized(), component, false);
        this.writeOption(result, "overlapEmbedObjects", panel.isOverlapEmbedObjects(), component, false);
        result.delete(result.length() - 1, result.length());
        if (component.getAttributes().get("visualOptions") != null) {
            result.append(this.writeVisualOptions(context, panel));
        }
        result.append("});");
        return result.toString();
    }

    public String writeEventHandlerFunction(FacesContext context, UIComponent component, String eventName) throws IOException {
        String event = (String)component.getAttributes().get(eventName);
        if (event != null && (event = event.trim()).length() != 0) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
            function.addParameter((Object)"event");
            function.addToBody((Object)event);
            return function.toScript();
        }
        return "";
    }

    private String writeVisualOptions(FacesContext context, UIPopupPanel panel) throws IOException {
        StringBuffer result = new StringBuffer();
        Iterator<Map.Entry<String, Object>> it = panel.getHandledVisualOptions().entrySet().iterator();
        if (it.hasNext()) {
            result.append(",\n");
        }
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            result.append(entry.getKey() + ": '" + entry.getValue() + "'");
            if (!it.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    static {
        ALLOWED_ATTACHMENT_OPTIONS.add("body");
        ALLOWED_ATTACHMENT_OPTIONS.add("parent");
        ALLOWED_ATTACHMENT_OPTIONS.add("form");
    }
}

