/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.ajax4jsf.application.ComponentsLoader;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;

public class ComponentsLoaderImpl
implements Transformer,
ComponentsLoader {
    private volatile Map classes = Collections.synchronizedMap(LazyMap.decorate(new HashMap(), (Transformer)this));
    private ClassLoader loader;

    public UIComponent createComponent(String type) {
        Class componentClass = (Class)this.classes.get(type);
        try {
            return (UIComponent)componentClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new FacesException("Error on create new instance of the component with class " + type, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException("IllegalAccess on attempt to create new instance of the component with class " + type, (Throwable)e);
        }
    }

    public Object transform(Object input) {
        if (null == input) {
            throw new NullPointerException("Name for a UIComponent class to restore is null");
        }
        ClassLoader loader = this.getClassLoader();
        Class<?> componentClass = null;
        try {
            componentClass = loader.loadClass(input.toString());
        }
        catch (ClassNotFoundException e) {
            throw new FacesException("Can't load class " + input.toString(), (Throwable)e);
        }
        return componentClass;
    }

    protected synchronized ClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = Thread.currentThread().getContextClassLoader();
            if (this.loader == null) {
                this.loader = this.getClass().getClassLoader();
            }
        }
        return this.loader;
    }
}

