/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.ajax4jsf.renderkit.RendererUtils.HTML;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ResponseWriterContentHandler implements ContentHandler {

	List<Object> events = new ArrayList<Object>();

	private String linkClass;

	public ResponseWriterContentHandler(String linkClass) {
		super();
		this.linkClass = linkClass;
	}

	public void characters(char[] ch, int start, int length)
			throws SAXException {

		events.add(new SAXTextEvent(new String(ch, start, length)));
	}

	public void endDocument() throws SAXException {
	}

	public void endElement(String uri, String localName, String name)
			throws SAXException {
		events.add(new SAXEndElementEvent(localName));
	}

	public void endPrefixMapping(String prefix) throws SAXException {
		throw new UnsupportedOperationException();
	}

	public void ignorableWhitespace(char[] ch, int start, int length)
			throws SAXException {
	}

	public void processingInstruction(String target, String data)
			throws SAXException {
		throw new UnsupportedOperationException();
	}

	public void setDocumentLocator(Locator locator) {
		throw new UnsupportedOperationException();
	}

	public void skippedEntity(String name) throws SAXException {
		throw new UnsupportedOperationException();
	}

	public void startDocument() throws SAXException {
	}

	public void startElement(String uri, String localName,
			String name, Attributes atts) throws SAXException {

		Map<String, String> attsMap = new HashMap<String, String>(atts.getLength());
		int length = atts.getLength();

		for (int i = 0; i < length; i++) {
			attsMap.put(atts.getLocalName(i), atts.getValue(i));
		}
		
		if (HTML.LINK_ELEMENT.equals(localName)) {
			attsMap.put(HTML.class_ATTRIBUTE, linkClass);
		}
		
		events.add(new SAXStartElementEvent(localName, attsMap));
	}

	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {
		throw new UnsupportedOperationException();
	}
	
}