/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.component.xpointer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.cocoon.pipeline.component.sax.SAXConsumer;
import org.apache.cocoon.pipeline.util.dom.DOMUtils;
import org.richfaces.cdk.Logger;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XPointerContext
implements NamespaceContext {
    private static final String XML = "xml";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private final Logger logger;
    private Map<String, String> prefixes = new HashMap<String, String>();
    private Document document;
    private final EntityResolver resolver;
    private InputSource source;
    private String xPointer;
    private SAXConsumer xmlConsumer;

    public XPointerContext(String xPointer, InputSource source, SAXConsumer xmlConsumer, EntityResolver resolver, Logger log) {
        this.xPointer = xPointer;
        this.source = source;
        this.xmlConsumer = xmlConsumer;
        this.resolver = resolver;
        this.logger = log;
    }

    public String getXPointer() {
        return this.xPointer;
    }

    public InputSource getSource() {
        return this.source;
    }

    public SAXConsumer getXmlConsumer() {
        return this.xmlConsumer;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Document getDocument() throws IOException, SAXException {
        if (this.document == null) {
            this.document = DOMUtils.toDOM(this.source, this.resolver);
        }
        return this.document;
    }

    public void addPrefix(String prefix, String namespaceURI) {
        if (prefix.equalsIgnoreCase(XML) || prefix.equals(XMLNS)) {
            return;
        }
        if (namespaceURI.equals(XML_NAMESPACE) || namespaceURI.equals(XMLNS_NAMESPACE)) {
            return;
        }
        this.prefixes.put(prefix, namespaceURI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.prefixes.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public Iterator getPrefixes(String namespaceURI) {
        throw new UnsupportedOperationException();
    }
}

