/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.layout;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.layout.Layout;
import org.primefaces.extensions.model.layout.LayoutOptions;
import org.primefaces.extensions.util.ComponentUtils;
import org.primefaces.renderkit.CoreRenderer;

public class LayoutRenderer
extends CoreRenderer {
    public void decode(FacesContext fc, UIComponent component) {
        this.decodeBehaviors(fc, component);
    }

    public void encodeBegin(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        Layout layout = (Layout)component;
        this.encodeScript(fc, layout);
        if (!layout.isFullPage()) {
            writer.startElement("div", (UIComponent)layout);
            writer.writeAttribute("id", (Object)layout.getClientId(fc), "id");
            if (layout.getStyle() != null) {
                writer.writeAttribute("style", (Object)layout.getStyle(), "style");
            }
            if (layout.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)layout.getStyleClass(), "styleClass");
            }
        }
    }

    public void encodeEnd(FacesContext fc, UIComponent component) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        Layout layout = (Layout)component;
        String clientId = layout.getClientId(fc);
        if (!layout.isFullPage()) {
            if (!layout.isStateCookie()) {
                writer.startElement("input", null);
                writer.writeAttribute("type", (Object)"hidden", null);
                writer.writeAttribute("id", (Object)(clientId + "_state"), null);
                writer.writeAttribute("name", (Object)(clientId + "_state"), null);
                writer.writeAttribute("autocomplete", (Object)"off", null);
                writer.endElement("input");
            }
            writer.endElement("div");
        }
    }

    public boolean getRendersChildren() {
        return false;
    }

    protected void encodeScript(FacesContext fc, Layout layout) throws IOException {
        ResponseWriter writer = fc.getResponseWriter();
        String clientId = layout.getClientId();
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('Layout', '" + layout.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        if (layout.isFullPage()) {
            writer.write(",forTarget:'body'");
        } else {
            writer.write(",forTarget:'" + ComponentUtils.escapeJQueryId((String)clientId) + "'");
        }
        boolean stateCookie = layout.isStateCookie();
        writer.write(",clientState:");
        if (stateCookie) {
            writer.write("true");
        } else {
            writer.write("false");
        }
        writer.write(",serverState:");
        ValueExpression stateVE = layout.getValueExpression(Layout.PropertyKeys.state.toString());
        if (stateVE != null && !layout.isFullPage() && !stateCookie) {
            writer.write("true");
            String state = layout.getState();
            if (StringUtils.isNotBlank((CharSequence)state)) {
                writer.write(",state:" + state);
            } else {
                writer.write(",state:{}");
            }
        } else {
            writer.write("false");
        }
        LayoutOptions layoutOptions = (LayoutOptions)layout.getOptions();
        if (layoutOptions != null) {
            writer.write(",options:" + layoutOptions.render());
        } else {
            writer.write(",options:{}");
        }
        this.encodeClientBehaviors(fc, layout);
        writer.write("},true);});");
        this.endScript(writer);
    }
}

