package org.planx.xpath.expr.operator;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.object.*;

/**
 * And operator
 **/
public class AndOperator extends Operator {
    public AndOperator(Expression e1, Expression e2) {
        super(e1, e2);
    }

    protected XObject evaluate(XObject o1, XObject o2, Navigator navigator)
                                                     throws XPathException {
        boolean result = (o1.booleanValue() && o2.booleanValue());
        return result ? XBoolean.TRUE : XBoolean.FALSE;
    }

    protected String operatorName() {
        return " and ";
    }
}
