package org.planx.xpath.expr;

import org.planx.xpath.expr.axis.Axis;

/**
 * A step consists of an {@link Axis}, {@link NodeTest}
 * and a list of predicates which are {@link Expression}
 * objects.
 **/
public class Step {
    private final Axis axis;
    private final NodeTest nodeTest;
    private final PredicateList predicates;

    /**
     * Construct a step with no predicates.
     **/
    public Step(Axis axis, NodeTest nodeTest) {
        this(axis, nodeTest, new PredicateList());
    }

    /**
     * Construct a step with the specified axis,
     * node test and predicate list.
     **/
    public Step(Axis axis, NodeTest nodeTest, PredicateList predicates) {
        this.axis = axis;
        this.nodeTest = nodeTest;
        this.predicates = predicates;
    }

    public Axis getAxis() {
        return axis;
    }

    public NodeTest getNodeTest() {
        return nodeTest;
    }

    public PredicateList getPredicates() {
        return predicates;
    }

    public String toString() {
        return axis.toString()+"::"+nodeTest.toString()+predicates.toString();
    }
}
