package org.planx.xmlstore.nodes;

import java.io.*;
import java.util.*;
import org.planx.msd.*;
import org.planx.msd.character.*;
import org.planx.msd.lang.EquivalenceClass;
import org.planx.msd.lang.EquivalenceClassDiscriminable;
import org.planx.msd.lang.EquivalenceClassDiscriminator;
import org.planx.msd.list.*;
import org.planx.msd.number.*;
import org.planx.msd.util.*;
import org.planx.xmlstore.*;
import org.planx.xmlstore.io.*;

/**
 * A <code>Discriminator</code> of <code>SystemNode</code>s.
 *
 * @author Thomas Ambus
 */
public class NodeDiscriminator extends AbstractDiscriminator<SystemNode> {
    private Discriminator<Byte> typeDisc;
    private Discriminator<CharSequence> valueDisc;
    private Discriminator<List<SystemNode>> childListDisc;
    private Discriminator<List<Attribute>> attrsListDisc;

    public NodeDiscriminator() {
        this(DiscriminatorFactory.instance().getMemory());
    }

    public NodeDiscriminator(Memory memory) {
        typeDisc      = new ByteDiscriminator(memory);
        valueDisc     = new CharSequenceDiscriminator<CharSequence>(memory);

        Discriminator<SystemNode> childDisc =
            new EquivalenceClassDiscriminator<SystemNode>();
        childListDisc = new SizeRandomAccessListDiscriminator<SystemNode>
            (childDisc, memory);

        Discriminator<Attribute> attrDisc =
            DVMAttribute.getDiscriminator(memory);
        attrsListDisc = new ShortSetDiscriminator<Attribute>(attrDisc, memory);
    }


    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                               final Extractor<U,? extends SystemNode,S> e) {

        // Check fast way out: only zero or one element
        int vsize = values.size();
        if (vsize == 0) return Collections.emptyList();
        if (vsize == 1) {
            List<S> l1 = Collections.singletonList(e.getValue(values.get(0)));
            return Collections.singletonList(l1);
        }

        Extractor<U,CharSequence,U> eValue = new Extractor<U,CharSequence,U>() {
            public CharSequence getLabel(U elm) {
                return e.getLabel(elm).getNodeValue();
            }
            public U getValue(U elm) {
                return elm;
            }
        };

        Extractor<U,Byte,U> eType = new Extractor<U,Byte,U>() {
            public Byte getLabel(U elm) {
                return e.getLabel(elm).getType();
            }
            public U getValue(U elm) {
                return elm;
            }
        };

        Extractor<U,List<SystemNode>,U> eChildren =
                new Extractor<U,List<SystemNode>,U>() {
            public List<SystemNode> getLabel(U elm) {
                return (List) e.getLabel(elm).getChildren();
            }
            public U getValue(U elm) {
                return elm;
            }
        };

        Extractor<U,List<Attribute>,S> eAttrs = new Extractor<U,List<Attribute>,S>() {
            public List<Attribute> getLabel(U elm) {
                return e.getLabel(elm).getAttributes();
            }
            public S getValue(U elm) {
                return e.getValue(elm);
            }
        };

        return Discriminators.discriminate(values,
                                valueDisc, eValue,
                         childListDisc, eChildren,
                                  typeDisc, eType,
                            attrsListDisc, eAttrs);
    }
}
