package org.planx.xmlstore.nodes;

import org.planx.msd.lang.*;
import org.planx.util.*;
import org.planx.xmlstore.Attribute;
import org.planx.xmlstore.Node;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.io.LocalLocator;
import org.planx.xmlstore.io.Streamers;
import org.planx.xmlstore.references.*;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractNode implements SystemNode {
    protected Object visitToken = null; // identify if node has already been visited
    protected EquivalenceClass eqCls = null; // efficient discrimination when child
    protected Reference ref = null; // optimization, typically ContentValueReference

    protected AbstractNode() {}

    public Object getVisitToken() {
        return visitToken;
    }

    public void setVisitToken(Object token) {
        this.visitToken = token;
    }

    public Reference getReference() {
        return ref;
    }

    public void setReference(Reference ref) {
        this.ref = ref;
    }

    public EquivalenceClass getEquivalenceClass() {
        if (eqCls == null) eqCls = new EquivalenceClass();
        return eqCls;
    }

    public void setEquivalenceClass(EquivalenceClass eqCls) {
        this.eqCls = eqCls;
    }

    public SystemNode get() {
        return this;
    }

    public boolean isMutable() {
        return false;
    }
}
