package org.planx.xmlstore.convert;

import java.io.*;
import com.megginson.sax.DataWriter;
import org.planx.xmlstore.Node;

/**
 * @author Henning Niss
 */
public class XMLOutputter {
    private int indent;

    /**
     * Construct an XML Outputter that with the default indent step.
     * The default indent step is currently 2.
     */
    public XMLOutputter() {
        this(2);
    }

    /**
     * Construct an XML Outputter that with the specified indent step.
     *
     * @param indent  the number of spaces to use as indentation.
     */
    public XMLOutputter(int indent) {
        this.indent = indent;
    }

    /**
     * Output a node as an XML document.
     * This method outputs a node as if it was the root node of a document
     * to the specified {@link java.io.Writer}.
     *
     * @param node  node to be output
     * @param out   writer to output to
     * @throws XMLException if an error occurs during writing.
     */
    public void output(Node node, Writer out) throws XMLException {
        DataWriter w = new DataWriter(out);
        w.setIndentStep(indent);
        SAXOutputter s = new SAXOutputter(w);
        s.output(node);
    }

    /**
     * Output a node as an XML document.
     * This method outputs a node as if it was the root node of a document
     * to the specified {@link java.io.OutputStream}.
     *
     * @param node  node to be output
     * @param os    output stream to output to
     * @throws XMLException if an error occurs during writing.
     */
    public void output(Node node, OutputStream os) throws XMLException {
        /*
        Writer out = new BufferedWriter(
                        new OutputStreamWriter(
                           new BufferedOutputStream(os)
                     ));
        */
        Writer out = new OutputStreamWriter(os);
        output(node, out);
    }
}
