package org.planx.msd.number;

import java.util.AbstractList;
import java.util.List;
import org.planx.msd.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>Short</code> objects.
 *
 * @author Thomas Ambus
 */
public class ShortDiscriminator extends NumberDiscriminator<Short> {
    /**
     * Constructs a new <code>ShortDiscriminator</code> that reuses the
     * memory of the specified <code>Memory</code>.
     */
    public ShortDiscriminator(Memory memory) {super(memory);}

    protected int bitsize() {return 16;}

    protected <U> ChunkExtractor<U> chunkExtractor(Extractor<U,? extends Short,?> e) {
        return new ChunkExtractor<U>(e) {
            public int getLabel(U elm) {
                Short value = e.getLabel(elm);
                return (value.intValue() >> offset) & CHUNK_MASK;
            }
        };
    }
}
