package org.planx.msd.number;

import java.util.AbstractList;
import java.util.List;
import org.planx.msd.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>Float</code> objects.
 *
 * @author Thomas Ambus
 */
public class FloatDiscriminator extends NumberDiscriminator<Float> {
    public FloatDiscriminator(Memory memory) {super(memory);}

    protected int bitsize() {return 32;}

    protected <U> ChunkExtractor<U> chunkExtractor(Extractor<U,
                                        ? extends Float,?> e) {
        return new ChunkExtractor<U>(e) {
            public int getLabel(U elm) {
                Float value = e.getLabel(elm);
                return (int) ((Float.floatToIntBits(value) >> offset)
                                                        & CHUNK_MASK);
            }
        };
    }
}
