package org.planx.msd.number;

import java.util.AbstractList;
import java.util.List;
import org.planx.msd.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>Byte</code> objects.
 *
 * @author Thomas Ambus
 */
public class ByteDiscriminator extends NumberDiscriminator<Byte> {
    public ByteDiscriminator(Memory memory) {super(memory);}

    protected int bitsize() {return 8;}

    protected <U> ChunkExtractor<U> chunkExtractor(Extractor<U,
            ? extends Byte,?> e) {
        return new ChunkExtractor<U>(e) {
            public int getLabel(U elm) {
                Byte value = e.getLabel(elm);
                return (value.intValue() >> offset) & CHUNK_MASK;
            }
        };
    }
}
