package org.planx.msd.lang;

/**
 * Thrown to indicate that a data structure could not be discriminated
 * because it contained one or more objects for which no discriminator
 * was known.
 *
 * @author Thomas Ambus
 */
public class NonDiscriminableObjectException extends RuntimeException {
    public NonDiscriminableObjectException() {
        super();
    }

    public NonDiscriminableObjectException(String message) {
        super(message);
    }

    public NonDiscriminableObjectException(Throwable cause) {
        super(cause.toString());
    }

    public NonDiscriminableObjectException(String msg, Throwable cause) {
        super(msg+" "+cause.toString());
    }
}
