package org.planx.msd.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * An equivalence class for use with <code>EquivalenceClassDiscriminable</code>
 * and <code>EquivalenceClassDiscriminator</code>. If two
 * <code>EquivalenceClassDiscriminable</code>s
 * point to the same <code>EquivalenceClass</code>, they are considered
 * equivalent.
 * <p>
 * Note: Some methods are package private to ensure that
 * <code>EquivalenceClassDiscriminator</code> is thread-safe. The class
 * is <code>final</code> to prevent application programmers from making
 * sub-classes that would not work with <code>EquivalenceClassDiscriminator</code>.
 *
 * @author Thomas Ambus
 */
public final class EquivalenceClass {
    private List members = null;

    public EquivalenceClass() {}

    /**
     * Returns <code>true</code> if the member list is empty.
     */
    boolean isEmpty() {
        return (members == null) || members.isEmpty();
    }

    /**
     * Adds the specified object to the end of the member list.
     * The specified object must be of type T, which is the type to be
     * returned by {@link #getListAndClear} once all objects have been
     * added. The reason that T  is not declared as a class type variable,
     * is that during the next discrimination
     * the actual type T could be different.
     */
    void add(Object o) {
        if (members == null) members = new ArrayList();
        members.add(o);
    }

    /**
     * Returns the contents of the member list and clears it for the next
     * discrimination use.
     */
    <T> List<T> getListAndClear() {
        if (members == null) return Collections.emptyList();
        List<T> result = (List<T>) members;
        members = null;
        return result;
    }
}
