package org.planx.msd.character;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.planx.msd.*;
import org.planx.msd.number.IntExtractor;
import org.planx.msd.util.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>Character</code> objects.
 * <p>
 * <b>Note that this implementation is not synchronized.</b> If
 * multiple threads access an instance of this class concurrently,
 * it must be synchronized externally.
 *
 * @author Thomas Ambus
 */
public class CharacterDiscriminator extends AbstractDiscriminator<Character> {
    private Memory memory;

    /**
     * Constructs a new <code>CharacterDiscriminator</code> reusing the
     * memory allocated in the specified <code>Memory</code>.
     */
    public CharacterDiscriminator(Memory memory) {
        this.memory = memory;
    }

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                final Extractor<U,? extends Character,S> e) {
        IntExtractor<U,S> intExt = new IntExtractor<U,S>() {
            public int getLabel(U elm) {
                return (int) e.getLabel(elm).charValue();
            }
            public S getValue(U elm) {
                return e.getValue(elm);
            }
        };
        return memory.discriminate(values, intExt);
    }
}
