package debug;

import java.io.*;
import java.util.*;

public class Debug {
    public static int traceSize = 200;
    public static boolean doTrace = false;
    public static boolean liveMeasure = false;
    public static boolean liveDebug = false;
    public static boolean isEnabled = false;

    private static Object semaphore = new Object();
    private static LinkedList<String> buf = new LinkedList<String>();
    private static List<DEntry> dbg = new ArrayList<DEntry>();
    private static long last = System.nanoTime();
    private static String dinfo = null;

    public static void out(Object string) {
        synchronized (semaphore) {
            String info = string.toString();
            if (doTrace) {
                buf.add(info);
                if (buf.size()>traceSize) buf.remove();
                return;
            }
            if (!isEnabled) return;
            if (liveDebug) {
                System.out.println(string);
                return;
            }

            boolean isFirst = (dinfo==null);
            if (isFirst) dinfo = "INIT";

            long now = System.nanoTime();
            long elapsed = now - last;
            last = now;
            DEntry d = new DEntry(dinfo, elapsed);
            dinfo = info;

            if (!isFirst) System.out.println(String.format("%1$8.3f s", d.elapsed/1e9D));
            System.out.print(String.format("%1$80s:", info));
        }
    }

    public static void trace() {
        synchronized (semaphore) {
            for (String s : buf) {
                System.out.println(s);
            }
        }
    }

    public static List<DEntry> dumpTiming() {
        synchronized (semaphore) {
            List<DEntry> d = dbg;
            dbg = new ArrayList<DEntry>();
            return d;
        }
    }

    private static List<DEntry> m_dbg = new ArrayList<DEntry>();
    private static long m_last = System.nanoTime();
    private static String m_dinfo = null;

    public static void beginMeasure(String info) {
        synchronized (semaphore) {
            m_last = System.nanoTime();
            m_dinfo = info;
        }
    }

    public static void endMeasure() {
        synchronized (semaphore) {
            long now = System.nanoTime();
            long elapsed = now - m_last;
            m_last = now;
            DEntry d = new DEntry(m_dinfo, elapsed);
            if (liveMeasure) {
                System.out.println(String.format("MEASURE %1$62s:%2$8.3f s", d.info, d.elapsed/1e9D));
            }
            m_dbg.add(d);
        }
    }

    public static List<DEntry> data() {
        synchronized (semaphore) {
            List<DEntry> d = m_dbg;
            m_dbg = new ArrayList<DEntry>();
            return d;
        }
    }

    public static String toString(List<DEntry> dbg) {
        synchronized (semaphore) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            for (DEntry d : dbg) {
                sb.append(d);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public static class DEntry {
        String info;
        long elapsed;

        DEntry(String s, long elapsed) {
            this.info = s;
            this.elapsed = elapsed;
        }

        public String toString() {
            return String.format("%1$70s:%2$8.3f s", info, elapsed/1e9D);
        }
    }
}
