/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.internal;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;
import org.jspecify.annotations.Nullable;

public class ClasspathJarNameDetector
extends TreeScanner {
    private final Set<String> jarNames = new LinkedHashSet<String>();

    public Set<String> classpathFor(JCTree input) {
        this.scan(input);
        return this.jarNames;
    }

    private void addJarNameFor(Symbol owner) {
        Symbol.ClassSymbol enclClass;
        Symbol.ClassSymbol classSymbol = enclClass = owner instanceof Symbol.ClassSymbol ? (Symbol.ClassSymbol)owner : owner.enclClass();
        while (enclClass.enclClass() != null && enclClass.enclClass() != enclClass) {
            enclClass = enclClass.enclClass();
        }
        JavaFileObject classfile = enclClass.classfile;
        if (classfile != null) {
            String uriStr = classfile.toUri().toString();
            Matcher matcher = Pattern.compile("([^/]*)?\\.jar!/").matcher(uriStr);
            if (matcher.find()) {
                String jarName = matcher.group(1);
                if (jarName.startsWith("rewrite-templating") || jarName.startsWith("error_prone_core")) {
                    return;
                }
                this.jarNames.add(jarName.replaceFirst("(-\\d+).*?$", "$1"));
            }
        }
    }

    @Override
    public void scan(JCTree tree) {
        if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.ClassSymbol && Character.isUpperCase(((JCTree.JCFieldAccess)tree).getIdentifier().toString().charAt(0))) {
            this.addJarNameFor(((JCTree.JCFieldAccess)tree).sym);
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)tree;
            Symbol.MethodSymbol methodSym = null;
            if (invocation.meth instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess methodAccess = (JCTree.JCFieldAccess)invocation.meth;
                if (methodAccess.sym instanceof Symbol.MethodSymbol) {
                    methodSym = (Symbol.MethodSymbol)methodAccess.sym;
                }
                if (methodAccess.selected != null && methodAccess.selected.type != null) {
                    this.addTypeAndTransitiveDependencies(methodAccess.selected.type);
                }
            } else if (invocation.meth instanceof JCTree.JCIdent) {
                JCTree.JCIdent methodIdent = (JCTree.JCIdent)invocation.meth;
                if (methodIdent.sym instanceof Symbol.MethodSymbol) {
                    methodSym = (Symbol.MethodSymbol)methodIdent.sym;
                }
            }
            if (methodSym != null) {
                this.addJarNameFor(methodSym.owner);
                if (methodSym.getReturnType() != null) {
                    this.addTypeAndTransitiveDependencies(methodSym.getReturnType());
                }
                for (Type thrownType : methodSym.getThrownTypes()) {
                    this.addTypeAndTransitiveDependencies(thrownType);
                }
            }
        }
        if (tree instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)tree;
            if (ident.sym instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)ident.sym;
                this.addJarNameFor(classSym);
                this.addTypeAndTransitiveDependencies(classSym.type);
            }
        }
        super.scan(tree);
    }

    private void addTypeAndTransitiveDependencies(@Nullable Type type) {
        if (type == null) {
            return;
        }
        if (type.tsym instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)type.tsym;
            this.addJarNameFor(classSym);
            Type superType = classSym.getSuperclass();
            if (superType != null && superType.tsym != null) {
                this.addTypeAndTransitiveDependencies(superType);
            }
            for (Type iface : classSym.getInterfaces()) {
                if (iface.tsym == null) continue;
                this.addTypeAndTransitiveDependencies(iface);
            }
        }
    }
}

