/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class SimplifyBooleanExpressionVisitor
extends JavaVisitor<ExecutionContext> {
    private final MethodMatcher isEmpty = new MethodMatcher("java.lang.String isEmpty()");
    private final MethodMatcher equals = new MethodMatcher("java.lang.String equals(java.lang.Object)");

    @Override
    public J visitBinary(J.Binary binary, ExecutionContext ctx) {
        Boolean result;
        J j = super.visitBinary(binary, ctx);
        J.Binary asBinary = (J.Binary)j;
        if (asBinary.getOperator() == J.Binary.Type.And) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                j = asBinary.getLeft();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
            } else if (this.isLiteralTrue(asBinary.getLeft())) {
                j = asBinary.getRight();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(""));
            } else if (!(asBinary.getLeft() instanceof MethodCall) && SemanticallyEqual.areEqual(asBinary.getLeft(), asBinary.getRight())) {
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Or) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                j = asBinary.getLeft();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
            } else if (this.isLiteralFalse(asBinary.getLeft())) {
                j = asBinary.getRight();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(""));
            } else if (!(asBinary.getLeft() instanceof MethodCall) && SemanticallyEqual.areEqual(asBinary.getLeft(), asBinary.getRight())) {
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Equal) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
                }
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(" "));
                }
            } else if (this.isLiteralFalse(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    j = SimplifyBooleanExpressionVisitor.not(asBinary.getRight());
                }
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    j = SimplifyBooleanExpressionVisitor.not(asBinary.getLeft());
                }
            } else {
                Boolean result2;
                j = this.maybeReplaceCompareWithNull(asBinary, true);
                if (j == asBinary && (result2 = this.compareNumericLiterals(asBinary)) != null) {
                    j = SimplifyBooleanExpressionVisitor.booleanLiteral(asBinary, result2);
                }
            }
        } else if (asBinary.getOperator() == J.Binary.Type.NotEqual) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
                }
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(" "));
                }
            } else if (this.isLiteralTrue(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    j = SimplifyBooleanExpressionVisitor.not(asBinary.getRight());
                }
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    j = SimplifyBooleanExpressionVisitor.not(asBinary.getLeft());
                }
            } else {
                Boolean result3;
                j = this.maybeReplaceCompareWithNull(asBinary, false);
                if (j == asBinary && (result3 = this.compareNumericLiterals(asBinary)) != null) {
                    j = SimplifyBooleanExpressionVisitor.booleanLiteral(asBinary, result3);
                }
            }
        } else if ((asBinary.getOperator() == J.Binary.Type.LessThan || asBinary.getOperator() == J.Binary.Type.GreaterThan || asBinary.getOperator() == J.Binary.Type.LessThanOrEqual || asBinary.getOperator() == J.Binary.Type.GreaterThanOrEqual) && (result = this.compareNumericLiterals(asBinary)) != null) {
            j = SimplifyBooleanExpressionVisitor.booleanLiteral(asBinary, result);
        }
        if (asBinary != j) {
            j = j.withPrefix(asBinary.getPrefix());
        }
        return j;
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, ExecutionContext ctx) {
        J j = super.visitParentheses(parens, ctx);
        if (j != parens && j instanceof J.Parentheses) {
            j = (J)new UnnecessaryParenthesesVisitor().visit(j, ctx, this.getCursor().getParentOrThrow());
        }
        return j;
    }

    @Override
    public J visitUnary(J.Unary unary, ExecutionContext ctx) {
        J j = super.visitUnary(unary, ctx);
        if (j instanceof J.Unary) {
            J.Unary asUnary = (J.Unary)j;
            if (asUnary.getOperator() == J.Unary.Type.Not) {
                j = this.unpackExpression(asUnary.getExpression(), asUnary);
            }
            if (asUnary != j) {
                j = j.withPrefix(asUnary.getPrefix());
            }
        }
        return j;
    }

    @Override
    public J visitTernary(J.Ternary ternary, ExecutionContext executionContext) {
        J j = super.visitTernary(ternary, executionContext);
        if (j instanceof J.Ternary) {
            J.Parentheses parenthesized;
            J.Ternary asTernary = (J.Ternary)j;
            if (asTernary.getCondition() instanceof J.Unary) {
                Expression negated = this.maybeNegate(asTernary.getCondition());
                if (negated != asTernary.getCondition()) {
                    j = asTernary.withCondition(negated).withTruePart(asTernary.getFalsePart()).withFalsePart(asTernary.getTruePart());
                }
            } else if (asTernary.getCondition() instanceof J.Literal) {
                if (this.isLiteralTrue(asTernary.getCondition())) {
                    j = asTernary.getTruePart();
                } else if (this.isLiteralFalse(asTernary.getCondition())) {
                    j = asTernary.getFalsePart();
                }
            } else if (asTernary.getCondition() instanceof J.Parentheses && (parenthesized = (J.Parentheses)asTernary.getCondition()).getTree() instanceof J.Literal) {
                if (this.isLiteralTrue((Expression)parenthesized.getTree())) {
                    j = asTernary.getTruePart();
                } else if (this.isLiteralFalse((Expression)parenthesized.getTree())) {
                    j = asTernary.getFalsePart();
                }
            }
        }
        return j;
    }

    private Expression unpackExpression(Expression expr, Expression j) {
        if (this.isLiteralTrue(expr)) {
            j = ((J.Literal)expr).withValue(false).withValueSource("false");
        } else if (this.isLiteralFalse(expr)) {
            j = ((J.Literal)expr).withValue(true).withValueSource("true");
        } else if (expr instanceof J.Unary && ((J.Unary)expr).getOperator() == J.Unary.Type.Not) {
            j = ((J.Unary)expr).getExpression();
        } else if (expr instanceof J.Parentheses) {
            Object parenthesized = ((J.Parentheses)expr).getTree();
            if (parenthesized instanceof J.Binary) {
                J.Binary binary = (J.Binary)parenthesized;
                J.Binary.Type negated = this.maybeNegate(binary.getOperator());
                if (negated != binary.getOperator()) {
                    j = binary.withOperator(negated).withPrefix(j.getPrefix());
                }
            } else if (parenthesized instanceof J.Unary) {
                J.Unary unary1 = (J.Unary)parenthesized;
                J.Unary.Type operator = unary1.getOperator();
                if (operator == J.Unary.Type.Not) {
                    j = (Expression)unary1.getExpression().withPrefix(j.getPrefix());
                }
            } else if (parenthesized instanceof J.Ternary) {
                J.Ternary ternary = (J.Ternary)parenthesized;
                j = ternary.withTruePart(this.maybeNegate(ternary.getTruePart())).withFalsePart(this.maybeNegate(ternary.getFalsePart())).withPrefix(j.getPrefix());
            } else if (parenthesized instanceof Expression) {
                j = this.unpackExpression((Expression)parenthesized, j);
            }
        }
        return j;
    }

    private Expression maybeNegate(Expression expr) {
        if (expr instanceof J.Binary) {
            J.Binary.Type negated = this.maybeNegate(((J.Binary)expr).getOperator());
            if (negated != ((J.Binary)expr).getOperator()) {
                return ((J.Binary)expr).withOperator(negated).withPrefix(expr.getPrefix());
            }
        } else {
            if (expr instanceof J.Unary && ((J.Unary)expr).getOperator() == J.Unary.Type.Not) {
                return (Expression)((J.Unary)expr).getExpression().withPrefix(expr.getPrefix());
            }
            if (expr instanceof J.Ternary) {
                J.Ternary ternary = (J.Ternary)expr;
                Expression negatedCondition = this.maybeNegate(ternary.getCondition());
                if (negatedCondition != ternary.getCondition()) {
                    return ternary.withCondition(negatedCondition).withTruePart(ternary.getFalsePart()).withFalsePart(ternary.getTruePart()).withPrefix(expr.getPrefix());
                }
            } else {
                if (this.isLiteralTrue(expr)) {
                    return ((J.Literal)expr).withValue(false).withValueSource("false");
                }
                if (this.isLiteralFalse(expr)) {
                    return ((J.Literal)expr).withValue(true).withValueSource("true");
                }
            }
        }
        return SimplifyBooleanExpressionVisitor.not(expr).withPrefix(expr.getPrefix());
    }

    private J.Binary.Type maybeNegate(J.Binary.Type operator) {
        switch (operator) {
            case LessThan: {
                return J.Binary.Type.GreaterThanOrEqual;
            }
            case GreaterThan: {
                return J.Binary.Type.LessThanOrEqual;
            }
            case LessThanOrEqual: {
                return J.Binary.Type.GreaterThan;
            }
            case GreaterThanOrEqual: {
                return J.Binary.Type.LessThan;
            }
            case Equal: {
                return J.Binary.Type.NotEqual;
            }
            case NotEqual: {
                return J.Binary.Type.Equal;
            }
        }
        return operator;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
        J j = super.visitMethodInvocation(method, executionContext);
        J.MethodInvocation asMethod = (J.MethodInvocation)j;
        Expression select = asMethod.getSelect();
        if (this.isEmpty.matches(asMethod) && select instanceof J.Literal && select.getType() == JavaType.Primitive.String) {
            return SimplifyBooleanExpressionVisitor.booleanLiteral(method, J.Literal.isLiteralValue(select, ""));
        }
        if (this.equals.matches(asMethod)) {
            Expression arg = asMethod.getArguments().get(0);
            if (arg instanceof J.Literal && select instanceof J.Literal) {
                return SimplifyBooleanExpressionVisitor.booleanLiteral(method, ((J.Literal)select).getValue().equals(((J.Literal)arg).getValue()));
            }
            if (SemanticallyEqual.areEqual(select, arg)) {
                return SimplifyBooleanExpressionVisitor.booleanLiteral(method, true);
            }
        }
        return j;
    }

    private boolean isLiteralTrue(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
    }

    private boolean isLiteralFalse(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean isNonNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() != JavaType.Primitive.Null;
    }

    private static boolean isNumericLiteral(Expression expression) {
        return expression instanceof J.Literal && ((JavaType.Primitive)expression.getType()).isNumeric();
    }

    private static boolean isIntegralType(Expression expression) {
        if (!(expression instanceof J.Literal)) {
            return false;
        }
        JavaType type = expression.getType();
        return type == JavaType.Primitive.Byte || type == JavaType.Primitive.Short || type == JavaType.Primitive.Int || type == JavaType.Primitive.Long;
    }

    private @Nullable Boolean compareNumericLiterals(J.Binary binary) {
        if (!SimplifyBooleanExpressionVisitor.isNumericLiteral(binary.getLeft()) || !SimplifyBooleanExpressionVisitor.isNumericLiteral(binary.getRight())) {
            return null;
        }
        Object leftValue = ((J.Literal)binary.getLeft()).getValue();
        Object rightValue = ((J.Literal)binary.getRight()).getValue();
        if (!(leftValue instanceof Number) || !(rightValue instanceof Number)) {
            return null;
        }
        if (SimplifyBooleanExpressionVisitor.isIntegralType(binary.getLeft()) && SimplifyBooleanExpressionVisitor.isIntegralType(binary.getRight())) {
            long left = ((Number)leftValue).longValue();
            long right = ((Number)rightValue).longValue();
            switch (binary.getOperator()) {
                case LessThan: {
                    return left < right;
                }
                case GreaterThan: {
                    return left > right;
                }
                case LessThanOrEqual: {
                    return left <= right;
                }
                case GreaterThanOrEqual: {
                    return left >= right;
                }
                case Equal: {
                    return left == right;
                }
                case NotEqual: {
                    return left != right;
                }
            }
            return null;
        }
        double left = ((Number)leftValue).doubleValue();
        double right = ((Number)rightValue).doubleValue();
        switch (binary.getOperator()) {
            case LessThan: {
                return left < right;
            }
            case GreaterThan: {
                return left > right;
            }
            case LessThanOrEqual: {
                return left <= right;
            }
            case GreaterThanOrEqual: {
                return left >= right;
            }
            case Equal: {
                return Double.compare(left, right) == 0;
            }
            case NotEqual: {
                return Double.compare(left, right) != 0;
            }
        }
        return null;
    }

    private J maybeReplaceCompareWithNull(J.Binary asBinary, boolean valueIfEqual) {
        Expression left = asBinary.getLeft();
        Expression right = asBinary.getRight();
        boolean leftIsNull = this.isNullLiteral(left);
        boolean rightIsNull = this.isNullLiteral(right);
        if (leftIsNull && rightIsNull) {
            return SimplifyBooleanExpressionVisitor.booleanLiteral(asBinary, valueIfEqual);
        }
        boolean leftIsNonNullLiteral = this.isNonNullLiteral(left);
        boolean rightIsNonNullLiteral = this.isNonNullLiteral(right);
        if (leftIsNull && rightIsNonNullLiteral || rightIsNull && leftIsNonNullLiteral) {
            return SimplifyBooleanExpressionVisitor.booleanLiteral(asBinary, !valueIfEqual);
        }
        return asBinary;
    }

    private static J.Literal booleanLiteral(J j, boolean value) {
        return new J.Literal(Tree.randomId(), j.getPrefix(), j.getMarkers(), value, String.valueOf(value), Collections.emptyList(), JavaType.Primitive.Boolean);
    }

    private static J.Unary not(Expression sideRetained) {
        if (!(sideRetained instanceof J.FieldAccess || sideRetained instanceof J.Identifier || sideRetained instanceof J.Literal || sideRetained instanceof J.MethodInvocation || sideRetained instanceof J.Parentheses || sideRetained instanceof J.Unary)) {
            sideRetained = new J.Parentheses<Expression>(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build(sideRetained));
        }
        return new J.Unary(Tree.randomId(), sideRetained.getPrefix(), sideRetained.getMarkers(), JLeftPadded.build(J.Unary.Type.Not), (Expression)sideRetained.withPrefix(Space.EMPTY).withMarkers(Markers.EMPTY), JavaType.Primitive.Boolean);
    }

    protected boolean shouldSimplifyEqualsOn(J j) {
        return true;
    }
}

