/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class PreferIncrementOperator
extends Recipe {
    public String getDisplayName() {
        return "Prefer increment/decrement and compound assignment operators";
    }

    public String getDescription() {
        return "Prefer the use of increment and decrement operators (`++`, `--`, `+=`, `-=`) over their more verbose equivalents.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Block visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = super.visitBlock(block, (Object)ctx);
                return b.withStatements(ListUtils.map((List)b.getStatements(), statement -> {
                    J.Assignment assignment;
                    if (statement instanceof J.Assignment && (assignment = (J.Assignment)statement).getAssignment() instanceof J.Binary) {
                        Expression binaryLeft;
                        Expression variable = assignment.getVariable();
                        J.Binary binary = (J.Binary)assignment.getAssignment();
                        if ((binary.getOperator() == J.Binary.Type.Addition || binary.getOperator() == J.Binary.Type.Subtraction) && SemanticallyEqual.areEqual((J)variable, (J)(binaryLeft = binary.getLeft()))) {
                            J.Literal literal;
                            Expression right = binary.getRight();
                            if (right instanceof J.Literal && (literal = (J.Literal)right).getValue() instanceof Integer && (Integer)literal.getValue() == 1) {
                                J.Unary.Type unaryType = binary.getOperator() == J.Binary.Type.Addition ? J.Unary.Type.PostIncrement : J.Unary.Type.PostDecrement;
                                return new J.Unary(Tree.randomId(), assignment.getPrefix(), assignment.getMarkers(), new JLeftPadded(Space.EMPTY, (Object)unaryType, Markers.EMPTY), (Expression)variable.withPrefix(Space.EMPTY), assignment.getType());
                            }
                            J.AssignmentOperation.Type opType = binary.getOperator() == J.Binary.Type.Addition ? J.AssignmentOperation.Type.Addition : J.AssignmentOperation.Type.Subtraction;
                            return new J.AssignmentOperation(Tree.randomId(), assignment.getPrefix(), assignment.getMarkers(), (Expression)variable.withPrefix(Space.EMPTY), new JLeftPadded(Space.SINGLE_SPACE, (Object)opType, Markers.EMPTY), (Expression)right.withPrefix(Space.SINGLE_SPACE), assignment.getType());
                        }
                    }
                    return statement;
                }));
            }
        };
    }
}

