/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.HashSet;
import java.util.Set;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class EugengoUtils
extends GeneratorUtil {
    private static Set<String> simpleTypes = new HashSet<String>();
    private static Set<String> primitiveTypes;

    public static String getCopyright(Model model) {
        return GeneratorUtil.findTagValue((String)"copyright", null, (Model)model);
    }

    public static boolean isService(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"Service") || EugengoUtils.isCrudService(classifier);
    }

    public static boolean isCrudService(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"CrudService");
    }

    public static boolean isWebService(ObjectModelClassifier classifier) {
        if (EugengoUtils.isCrudService(classifier)) {
            return true;
        }
        if (!EugengoUtils.isService(classifier)) {
            return false;
        }
        for (ObjectModelOperation op : classifier.getOperations()) {
            if (!EugengoUtils.isRemote(op)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDto(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"Dto");
    }

    public static boolean isBusinessEntity(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"BusinessEntity");
    }

    public static boolean isDao(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"Dao");
    }

    public static boolean isEntity(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"Entity");
    }

    public static boolean isException(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"Exception") || EugengoUtils.isBusinessException(classifier);
    }

    public static boolean isBusinessException(ObjectModelClassifier classifier) {
        return EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)"BusinessException");
    }

    public static boolean isRemote(ObjectModelOperation op) {
        return EugengoUtils.hasStereotype((ObjectModelElement)op, (String)"Remote");
    }

    public static String extractModelName(Model model) {
        String result = model.getName();
        if (result.contains("::")) {
            result = result.replaceAll("::", ".");
        }
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String normalizeCapitalName(String name) {
        String result = "";
        for (int idx = 0; idx < name.length(); ++idx) {
            char c = name.charAt(idx);
            if (Character.isUpperCase(c)) {
                result = result + "_";
            }
            result = result + Character.toUpperCase(c);
        }
        if (result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String getTagValue(ObjectModelAttribute attr, String tagName, String defaultValue) {
        String value = attr.getTagValue(tagName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean isPrimitiveType(ObjectModelAttribute attr) {
        String type = attr.getType();
        if (type.startsWith("java.lang.")) {
            type = type.substring(11);
        }
        return primitiveTypes.contains(type);
    }

    static {
        simpleTypes.add("void");
        simpleTypes.add("boolean");
        simpleTypes.add("byte");
        simpleTypes.add("short");
        simpleTypes.add("int");
        simpleTypes.add("long");
        simpleTypes.add("float");
        simpleTypes.add("double");
        primitiveTypes = new HashSet<String>();
        primitiveTypes.add("byte");
        primitiveTypes.add("Byte");
        primitiveTypes.add("short");
        primitiveTypes.add("Short");
        primitiveTypes.add("int");
        primitiveTypes.add("Integer");
        primitiveTypes.add("long");
        primitiveTypes.add("Long");
        primitiveTypes.add("float");
        primitiveTypes.add("Float");
        primitiveTypes.add("double");
        primitiveTypes.add("Double");
        primitiveTypes.add("char");
        primitiveTypes.add("Char");
        primitiveTypes.add("boolean");
        primitiveTypes.add("Boolean");
    }
}

