/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.util.ListenerSet;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

public class WikittyServiceNotifier
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceNotifier.class);
    protected ListenerSet<WikittyListener> allWikittyServiceListeners = new ListenerSet();
    protected ListenerSet<WikittyListener> localWikittyServiceListeners = new ListenerSet();
    protected ListenerSet<WikittyListener> remoteWikittyServiceListeners = new ListenerSet();
    protected WikittyListener notifier;
    protected LinkedBlockingQueue<WikittyEvent> eventToSend = new LinkedBlockingQueue();
    protected EventThread eventThread = new EventThread(this.eventToSend, this.allWikittyServiceListeners, this.localWikittyServiceListeners, this.remoteWikittyServiceListeners);

    public WikittyServiceNotifier(ApplicationConfig config, WikittyService ws, RemoteNotifierTransporter transporter) {
        super(ws);
        if (transporter != null) {
            transporter.setWikittyServiceNotifier(this);
            this.notifier = new EventPropagator(config, this, transporter);
            this.addWikittyServiceListener(this.notifier, WikittyService.ServiceListenerType.LOCAL);
        }
        if (log.isInfoEnabled()) {
            if (transporter == null) {
                log.info((Object)"RemoteNotifier synchronisation not used ");
            } else {
                log.info((Object)("RemoteNotifier transporter: " + transporter.getClass().getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        switch (type) {
            case ALL: {
                ListenerSet<WikittyListener> listenerSet = this.allWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.allWikittyServiceListeners.add((Object)listener);
                    break;
                }
            }
            case LOCAL: {
                ListenerSet<WikittyListener> listenerSet = this.localWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.localWikittyServiceListeners.add((Object)listener);
                    break;
                }
            }
            case REMOTE: {
                ListenerSet<WikittyListener> listenerSet = this.remoteWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.remoteWikittyServiceListeners.add((Object)listener);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        switch (type) {
            case ALL: {
                ListenerSet<WikittyListener> listenerSet = this.allWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.allWikittyServiceListeners.remove((Object)listener);
                    break;
                }
            }
            case LOCAL: {
                ListenerSet<WikittyListener> listenerSet = this.localWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.localWikittyServiceListeners.remove((Object)listener);
                    break;
                }
            }
            case REMOTE: {
                ListenerSet<WikittyListener> listenerSet = this.remoteWikittyServiceListeners;
                synchronized (listenerSet) {
                    this.remoteWikittyServiceListeners.remove((Object)listener);
                    break;
                }
            }
        }
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        WikittyEvent result = this.getDelegate().clear(securityToken);
        this.fireEvent(result);
        return result;
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        WikittyEvent result = this.getDelegate().store(securityToken, wikitties, force);
        this.fireEvent(result);
        return result;
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyEvent result = this.getDelegate().storeExtension(securityToken, exts);
        this.fireEvent(result);
        return result;
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        WikittyEvent result = this.getDelegate().deleteExtension(securityToken, extNames);
        this.fireEvent(result);
        return result;
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        WikittyEvent result = this.getDelegate().delete(securityToken, ids);
        this.fireEvent(result);
        return result;
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String wikittyId) {
        WikittyEvent result = this.getDelegate().deleteTree(securityToken, wikittyId);
        this.fireEvent(result);
        return result;
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        WikittyEvent result = this.getDelegate().replay(securityToken, events, force);
        this.fireEvent(result);
        return result;
    }

    protected void fireEvent(WikittyEvent event) {
        EventThread thread = this.getEventThread();
        if (thread.stopAsked()) {
            throw new WikittyException("Event thread dispatcher is stopped, no more event can be send");
        }
        this.eventToSend.offer(event);
        if (!thread.isAlive()) {
            thread.start();
        }
    }

    public void processRemoteEvent(WikittyEvent event) {
        event.setSource(this);
        event.setRemote(true);
        this.fireEvent(event);
    }

    public EventThread getEventThread() {
        return this.eventThread;
    }

    protected void finalize() throws Throwable {
        this.getEventThread().askStop();
        super.finalize();
    }

    public static class EventPropagator
    implements WikittyListener {
        private static Log log = LogFactory.getLog(EventPropagator.class);
        protected WikittyServiceNotifier ws;
        protected RemoteNotifierTransporter transporter;

        public EventPropagator(ApplicationConfig config, WikittyServiceNotifier ws, RemoteNotifierTransporter transporter) {
            this.ws = ws;
            this.transporter = transporter;
        }

        protected void sendMessage(WikittyEvent event) {
            block4: {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Try to send message : " + event));
                    }
                    this.transporter.sendMessage(event);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message is sent : " + event));
                    }
                }
                catch (Exception eee) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Can't send message", (Throwable)eee);
                }
            }
        }

        @Override
        public void putWikitty(WikittyEvent event) {
            this.sendMessage(event);
        }

        @Override
        public void removeWikitty(WikittyEvent event) {
            this.sendMessage(event);
        }

        @Override
        public void clearWikitty(WikittyEvent event) {
            this.sendMessage(event);
        }

        @Override
        public void putExtension(WikittyEvent event) {
            this.sendMessage(event);
        }

        @Override
        public void removeExtension(WikittyEvent event) {
            this.sendMessage(event);
        }

        @Override
        public void clearExtension(WikittyEvent event) {
            this.sendMessage(event);
        }
    }

    public static interface RemoteNotifierTransporter {
        public void setWikittyServiceNotifier(WikittyServiceNotifier var1);

        public void sendMessage(WikittyEvent var1) throws Exception;
    }

    public static class EventThread
    extends Thread {
        protected boolean mustBeRunning = true;
        protected SortedMap<Long, Object> waiter = new TreeMap<Long, Object>();
        protected LinkedBlockingQueue<WikittyEvent> eventToSend;
        protected ListenerSet<WikittyListener> allWikittyServiceListeners;
        protected ListenerSet<WikittyListener> localWikittyServiceListeners;
        protected ListenerSet<WikittyListener> remoteWikittyServiceListeners;
        protected long lastEventTime = 0L;

        public EventThread(LinkedBlockingQueue<WikittyEvent> eventToSend, ListenerSet<WikittyListener> allWikittyServiceListeners, ListenerSet<WikittyListener> localWikittyServiceListeners, ListenerSet<WikittyListener> remoteWikittyServiceListeners) {
            super("wikitty-event-thread");
            this.eventToSend = eventToSend;
            this.allWikittyServiceListeners = allWikittyServiceListeners;
            this.localWikittyServiceListeners = localWikittyServiceListeners;
            this.remoteWikittyServiceListeners = remoteWikittyServiceListeners;
        }

        protected void askStop() {
            this.mustBeRunning = false;
        }

        public boolean stopAsked() {
            return !this.mustBeRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor(long eventTime) throws InterruptedException {
            Object mutex = null;
            EventThread.sleep(1L);
            Object object = this.waiter;
            synchronized (object) {
                if (eventTime <= this.lastEventTime) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("event deja passe " + eventTime + " <= " + this.lastEventTime));
                    }
                    return;
                }
                mutex = this.waiter.get(eventTime);
                if (mutex == null) {
                    mutex = new Object();
                    this.waiter.put(eventTime, mutex);
                }
            }
            object = mutex;
            synchronized (object) {
                mutex.wait();
            }
        }

        @Override
        public void run() {
            while (this.mustBeRunning) {
                this.processEventQueue();
            }
            this.processEventQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected void processEventQueue() {
            try {
                WikittyEvent event;
                while (null != (event = this.eventToSend.poll(5L, TimeUnit.SECONDS))) {
                    Object object;
                    Object mutex;
                    Object object2;
                    try {
                        object2 = this.allWikittyServiceListeners;
                        // MONITORENTER : object2
                        for (WikittyEvent.WikittyEventType type : event.getType()) {
                            this.allWikittyServiceListeners.fire(type.listenerMethodName, (Object)event);
                        }
                        // MONITOREXIT : object2
                    }
                    catch (Exception eee) {
                        log.error((Object)"Can't notify listener", (Throwable)eee);
                    }
                    try {
                        ListenerSet<WikittyListener> eee;
                        if (event.isRemote()) {
                            eee = this.remoteWikittyServiceListeners;
                            // MONITORENTER : eee
                            for (WikittyEvent.WikittyEventType type : event.getType()) {
                                this.remoteWikittyServiceListeners.fire(type.listenerMethodName, (Object)event);
                            }
                            // MONITOREXIT : eee
                        } else {
                            eee = this.localWikittyServiceListeners;
                            // MONITORENTER : eee
                            for (WikittyEvent.WikittyEventType type : event.getType()) {
                                this.localWikittyServiceListeners.fire(type.listenerMethodName, (Object)event);
                            }
                            // MONITOREXIT : eee
                        }
                    }
                    catch (Exception eee) {
                        log.error((Object)"Can't notify listener", (Throwable)eee);
                    }
                    object2 = this.waiter;
                    // MONITORENTER : object2
                    this.lastEventTime = event.getTime();
                    SortedMap<Long, Object> subwaiter = this.waiter.headMap(event.getTime());
                    Iterator<Map.Entry<Long, Object>> i = subwaiter.entrySet().iterator();
                    while (i.hasNext()) {
                        mutex = i.next().getValue();
                        i.remove();
                        object = mutex;
                        // MONITORENTER : object
                        mutex.notifyAll();
                        // MONITOREXIT : object
                    }
                    if (!this.waiter.isEmpty()) {
                        Long time = this.waiter.firstKey();
                        while (time.equals(event.getTime())) {
                            object = mutex = this.waiter.remove(time);
                            // MONITORENTER : object
                            mutex.notifyAll();
                            // MONITOREXIT : object
                            if (this.waiter.isEmpty()) break;
                            time = this.waiter.firstKey();
                        }
                    }
                    // MONITOREXIT : object2
                }
                return;
            }
            catch (InterruptedException eee) {
                log.error((Object)"Notification thread error", (Throwable)eee);
            }
        }
    }
}

