/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.query.ListObjectOrMap;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;

public class FunctionYear
extends WikittyQueryFunction {
    private static Log log = LogFactory.getLog(FunctionYear.class);

    public FunctionYear(String name) {
        super("year", name, null);
    }

    public FunctionYear(String name, WikittyQueryFunction arg) {
        super("year", name, Collections.singletonList(arg));
    }

    public FunctionYear(String methodName, String name, List<WikittyQueryFunction> args) {
        super(methodName, name, args);
        if (args.size() != 1) {
            throw new IllegalArgumentException("Year accept only one argument");
        }
    }

    @Override
    public int getNumArg() {
        return 1;
    }

    @Override
    public List<Map<String, Object>> call(WikittyQuery query, List<Map<String, Object>> data) {
        WikittyQueryFunction f = this.getArgs().get(0);
        data = f.call(query, data);
        ListObjectOrMap result = new ListObjectOrMap();
        for (Map<String, Object> m : data) {
            for (Map.Entry<String, Object> s : m.entrySet()) {
                String k = (String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)s.getKey());
                Object v = s.getValue();
                if (v instanceof Collection) {
                    result.add(k, (Object)this.getYear((Collection)v));
                    continue;
                }
                result.add(k, this.getYear(v));
            }
        }
        return result;
    }

    protected Collection getYear(Collection c) {
        ArrayList<Object> result = new ArrayList<Object>(c.size());
        for (Object o : c) {
            result.add(this.getYear(o));
        }
        return result;
    }

    protected Object getYear(Object o) {
        Object result = o;
        Date d = null;
        try {
            d = WikittyUtil.toDate(o);
        }
        catch (Exception eee) {
            log.debug((Object)String.format("can't convert '%s' object to date, keep object and don't extract year", o), (Throwable)eee);
        }
        if (d != null) {
            result = DateUtil.getDefaultCalendar((Date)d).get(1);
        }
        return result;
    }
}

