/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.function;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.query.ListObjectOrMap;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;

public class FunctionSum
extends WikittyQueryFunction {
    private static Log log = LogFactory.getLog(FunctionSum.class);

    public FunctionSum(String name) {
        super("Sum", name, null);
    }

    public FunctionSum(String name, WikittyQueryFunction arg) {
        super("Sum", name, Collections.singletonList(arg));
    }

    public FunctionSum(String methodName, String name, List<WikittyQueryFunction> args) {
        super(methodName, name, args);
        if (args.size() != 1) {
            throw new IllegalArgumentException("Sum accept only one argument");
        }
    }

    @Override
    public int getNumArg() {
        return 1;
    }

    @Override
    public List<Map<String, Object>> call(WikittyQuery query, List<Map<String, Object>> data) {
        WikittyQueryFunction f = this.getArgs().get(0);
        data = f.call(query, data);
        BigDecimal total = new BigDecimal(0);
        for (Map<String, Object> o : data) {
            if (o.size() > 1) {
                throw new IllegalStateException("Sum function can't take data, with more than one field");
            }
            for (Object s : o.values()) {
                if (s instanceof Collection) {
                    for (Object e : (Collection)s) {
                        BigDecimal v = WikittyUtil.toBigDecimal(e);
                        total = total.add(v);
                    }
                    continue;
                }
                BigDecimal v = WikittyUtil.toBigDecimal(s);
                total = total.add(v);
            }
        }
        ListObjectOrMap result = new ListObjectOrMap();
        result.add(this.getName(), (Object)total);
        return result;
    }
}

