/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.query.ListObjectOrMap;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.function.WikittyQueryFunction;

public class FunctionAvg
extends WikittyQueryFunction {
    private static Log log = LogFactory.getLog(FunctionAvg.class);

    public FunctionAvg(String name) {
        super("Avg", name, null);
    }

    public FunctionAvg(String name, WikittyQueryFunction arg) {
        super("Avg", name, Collections.singletonList(arg));
    }

    public FunctionAvg(String methodName, String name, List<WikittyQueryFunction> args) {
        super(methodName, name, args);
        if (args.size() != 1) {
            throw new IllegalArgumentException("Sum accept only one argument");
        }
    }

    @Override
    public int getNumArg() {
        return 1;
    }

    @Override
    public List<Map<String, Object>> call(WikittyQuery query, List<Map<String, Object>> data) {
        WikittyQueryFunction f = this.getArgs().get(0);
        data = f.call(query, data);
        BigDecimal total = new BigDecimal(0);
        int cpt = 0;
        for (Map<String, Object> o : data) {
            if (o.size() > 1) {
                throw new IllegalStateException("Avg function can't take data, with more than one field");
            }
            for (Object s : o.values()) {
                if (s instanceof Collection) {
                    for (Object e : (Collection)s) {
                        BigDecimal v = WikittyUtil.toBigDecimal(e);
                        total = total.add(v);
                        ++cpt;
                    }
                    continue;
                }
                BigDecimal v = WikittyUtil.toBigDecimal(s);
                total = total.add(v);
                ++cpt;
            }
        }
        BigDecimal avg = cpt == 0 ? new BigDecimal(0) : total.divide(new BigDecimal(cpt), 20, RoundingMode.HALF_UP);
        ListObjectOrMap result = new ListObjectOrMap();
        result.add(this.getName(), (Object)avg);
        return result;
    }
}

