/*
 * #%L
 * Nuiton Web :: Nuiton Struts 2
 * 
 * $Id: TopiaTransactionInterceptor.java 125 2011-10-28 20:54:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-parent-1.5/nuiton-struts2/src/main/java/org/nuiton/web/struts2/interceptor/TopiaTransactionInterceptor.java $
 * %%
 * Copyright (C) 2010 - 2011 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.web.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaTransactionAware;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;


/**
 * Same interceptor as {@link OpenTopiaTransactionInterceptor} but close
 * the transaction after action is called. The transaction will be commited
 * (unless asked otherwise) and closed.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 * @deprecated since 1.5, will be removed soon
 */
@Deprecated
public abstract class TopiaTransactionInterceptor extends OpenTopiaTransactionInterceptor {

    /** To specify on your action or method that you never want any commit. */
    @Retention(RetentionPolicy.RUNTIME)
    @Target({ElementType.TYPE, ElementType.METHOD})
    public @interface NoCommit {
    }

    private static final long serialVersionUID = 1L;
    
    /** Logger. */
    private static final Log log =
            LogFactory.getLog(TopiaTransactionInterceptor.class);

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {

        TopiaTransactionAware transactionAware = null;

        Object action = invocation.getProxy().getAction();

        if (action instanceof TopiaTransactionAware) {
            transactionAware = (TopiaTransactionAware) action;
        }

        if (transactionAware == null) {

            // not a transaction aware action, direct skip this interceptor
            return invocation.invoke();
        }

        // creates a proxy of a lazy transaction

        TopiaTransactionProxyInvocationHandler proxyInvocationHandler =
                new TopiaTransactionProxyInvocationHandler();

        TopiaContext proxy = (TopiaContext) Proxy.newProxyInstance(
                getClass().getClassLoader(),
                new Class<?>[]{TopiaContext.class,
                               TopiaContextImplementor.class},
                proxyInvocationHandler
        );

        // set the transaction in the action
        transactionAware.setTransaction(proxy);

        try {

            return invocation.invoke();

        } finally {

            closeTransaction(proxyInvocationHandler.getTransaction(), action, invocation);

        }
    }

    protected void closeTransaction(TopiaContext transaction, Object action,
                                   ActionInvocation invocation) throws TopiaException {

        boolean commitNeeded = isCommitNeeded(action, invocation);

        if (transaction != null && ! transaction.isClosed()) {
            try {
                if (commitNeeded) {

                    // commit the opened transaction
                    if (log.isDebugEnabled()) {
                        log.debug("Commit transaction " + transaction);
                    }
                    transaction.commitTransaction();
                }
            } finally {

                // close the opened transaction
                if (log.isDebugEnabled()) {
                    log.debug("Close transaction " + transaction);
                }
                transaction.closeContext();
            }
        }
    }

    protected boolean isCommitNeeded(Object action,
                                   ActionInvocation invocation) {
        Class<?> actionType = action.getClass();
        boolean noCommit = actionType.isAnnotationPresent(NoCommit.class);
        if (noCommit) {

            // a no commit annotation was found on the top of action
            if (log.isDebugEnabled()) {
                log.debug("NoCommit annotation found on action " +
                          actionType.getName());
            }
            return false;
        }

        // try to look on the methodName
        String methodName = invocation.getProxy().getMethod();
        if (methodName == null) {

            // no methodName specify, means the execute one
            methodName = "execute";
        }
        Method method;
        try {
            method = actionType.getMethod(methodName);
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        noCommit = method.isAnnotationPresent(NoCommit.class);
        if (noCommit) {
            if (log.isDebugEnabled()) {
                log.debug("NoCommit annotation found on action methodName  " +
                          actionType.getName() + "#" + methodName);
            }
        }
        return !noCommit;
    }

}