package org.nuiton.web.security;

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Tue Aug 26 18:11:02 CEST 2014")
public abstract class SecurityRoleAbstract extends AbstractTopiaEntity implements SecurityRole {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : permissions
     */
    protected Collection<String> permissions;

    private static final long serialVersionUID = 4049127909472219447L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_PERMISSIONS, Collection.class, String.class, permissions);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void addPermissions(String permissions) {
        if (this.permissions == null) {
            this.permissions = new LinkedList<String>();
        }
        this.permissions.add(permissions);
    }

    @Override
    public void addAllPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String item : permissions) {
            addPermissions(item);
        }
    }

    @Override
    public void setPermissions(Collection<String> permissions) {
        this.permissions = permissions;
    }

    @Override
    public void removePermissions(String permissions) {
        if (this.permissions == null || !this.permissions.remove(permissions)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearPermissions() {
        if (this.permissions == null) {
            return;
        }
        this.permissions.clear();
    }

    @Override
    public Collection<String> getPermissions() {
        return permissions;
    }

    @Override
    public int sizePermissions() {
        if (permissions == null) {
            return 0;
        }
        return permissions.size();
    }

    @Override
    public boolean isPermissionsEmpty() {
        int size = sizePermissions();
        return size == 0;
    }

    @Override
    public boolean isPermissionsNotEmpty() {
        boolean empty = isPermissionsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsPermissions(String permissions) {
        boolean contains = this.permissions !=null && this.permissions.contains(permissions);
        return contains;
    }

} //SecurityRoleAbstract
