/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.rss.FeedData;
import org.nuiton.rss.FeedHTMLRenderer;
import org.nuiton.rss.FeedRenderer;
import org.nuiton.rss.FeedRendererConfig;
import org.nuiton.rss.FeedURLResolver;
import org.nuiton.rss.HTMLCleaner;
import org.nuiton.rss.HTMLScriptCleaner;
import org.nuiton.rss.RSSConfig;
import org.nuiton.rss.SimpleFeedURLResolver;

public class RSSHelper {
    static final Log log = LogFactory.getLog(RSSHelper.class);
    protected FeedURLResolver resolver;
    protected ReferenceMap feeds = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);
    protected FeedRenderer renderer;

    public static RSSHelper newDefaultInstance() throws Exception {
        FeedURLResolver r = (FeedURLResolver)RSSConfig.DEFAULT_RESOLVER_CLASS.newInstance();
        FeedRenderer rr = (FeedRenderer)RSSConfig.DEFAULT_RENDERER_CLASS.newInstance();
        RSSHelper helper = new RSSHelper(r, rr);
        return helper;
    }

    public RSSHelper() {
        this((FeedURLResolver)new SimpleFeedURLResolver(), (FeedRenderer)new FeedHTMLRenderer(new HTMLCleaner[]{new HTMLScriptCleaner()}));
    }

    public RSSHelper(FeedURLResolver resolver, FeedRenderer renderer) {
        this.resolver = resolver;
        this.renderer = renderer;
    }

    public void setResolver(FeedURLResolver resolver) {
        this.resolver = resolver;
    }

    public void setRenderer(FeedRenderer renderer) {
        this.renderer = renderer;
    }

    public FeedRenderer getRenderer() {
        return this.renderer;
    }

    public FeedURLResolver getResolver() {
        return this.resolver;
    }

    public void removeFeed(String feedName) {
        this.feeds.remove((Object)feedName);
    }

    public String getHTML(String feedName, String representation, Integer nbItem, boolean forceReload) {
        try {
            FeedData feed = (FeedData)this.feeds.get((Object)feedName);
            if (forceReload || feed == null || feed.getLastRetrived() + RSSConfig.TIME_FORCE_RETRIEVED < System.currentTimeMillis()) {
                feed = this.resolver.resolv(feedName);
                if (feed == null) {
                    log.warn((Object)("could not find feed for " + feedName));
                    return "<span class='feed-error'>No feed found for " + feedName + "</span>";
                }
                this.feeds.put((Object)feedName, (Object)feed);
            }
            FeedRendererConfig c = representation != null ? new FeedRendererConfig(representation) : feed.getRendererConfig();
            int nb = nbItem != null ? nbItem.intValue() : feed.getNbItem();
            SyndFeed sf = feed.getFeed();
            List syndEntries = sf.getEntries();
            if (nb >= 0 && syndEntries.size() >= nb) {
                syndEntries = syndEntries.subList(syndEntries.size() - nb, syndEntries.size());
            }
            SyndEntry[] items = syndEntries.toArray(new SyndEntry[syndEntries.size()]);
            String result = this.renderer.render(c, sf, items);
            return result;
        }
        catch (MalformedURLException eee) {
            log.warn((Object)("Can't resolv feed url: " + feedName), (Throwable)eee);
            return "<span class='feed-error'>" + eee.getMessage() + "</span>";
        }
    }
}

