/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuiton.rss.BaseServlet;
import org.nuiton.rss.ConfigInitializer;
import org.nuiton.rss.FeedType;
import org.nuiton.rss.Field;
import org.nuiton.rss.RSSGenerator;
import org.nuiton.rss.RSSGeneratorConfig;
import org.nuiton.rss.RSSIOUtil;

public class RSSGeneratorServlet
extends BaseServlet<RSSGenerator> {
    private static final long serialVersionUID = 1L;

    public void doCreateFeed(HttpServletRequest request, HttpServletResponse response, String feedName, File file) throws ServletException, IOException {
        String type = request.getParameter("feedType");
        FeedType feedType = null;
        if (type != null) {
            try {
                feedType = FeedType.valueOf((String)type);
            }
            catch (Exception e) {
                feedType = null;
            }
        }
        if (feedType == null) {
            feedType = ((RSSGenerator)this.delegate).getFormat();
        }
        String description = request.getParameter("feedDescription");
        String link = request.getParameter("feedLink");
        String author = request.getParameter("feedAuthor");
        String categories = request.getParameter("feedCategories");
        HashMap<Field, String> values = new HashMap<Field, String>();
        values.put(Field.NAME, feedName);
        this.addFieldValue(Field.DESCRIPTION, description, values);
        this.addFieldValue(Field.LINK, link, values);
        this.addFieldValue(Field.AUTHOR, author, values);
        this.addFieldValue(Field.CATEGORY, categories, values);
        values.put(Field.TIME, RSSGenerator.DATE_PARSER.format(new Date()));
        try {
            ((RSSGenerator)this.delegate).createFeedFile(file.toURI().toURL(), feedType, values);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        String redirect = request.getParameter("from");
        if (redirect != null) {
            response.sendRedirect(redirect);
        }
    }

    public void doDeleteFeed(HttpServletRequest request, HttpServletResponse response, String feedName, File file) throws ServletException, IOException {
        try {
            ((RSSGenerator)this.delegate).deleteFeedFile(file.toURI().toURL());
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        String redirect = request.getParameter("from");
        if (redirect != null) {
            response.sendRedirect(redirect);
        }
    }

    public void doAddItem(HttpServletRequest request, HttpServletResponse response, String feedName, File file) throws ServletException, IOException {
        Integer nbItems = this.convertToInt(request.getParameter("nbItems"));
        if (nbItems == null) {
            nbItems = RSSGeneratorConfig.DEFAULT_GENERATOR_NB_ITEM;
        }
        String description = request.getParameter("itemDescription");
        String link = request.getParameter("itemLink");
        String author = request.getParameter("itemAuthor");
        String name = request.getParameter("itemName");
        HashMap<Field, String> values = new HashMap<Field, String>();
        this.addFieldValue(Field.NAME, name, values);
        this.addFieldValue(Field.DESCRIPTION, description, values);
        this.addFieldValue(Field.LINK, link, values);
        this.addFieldValue(Field.AUTHOR, author, values);
        values.put(Field.TIME, RSSGenerator.DATE_PARSER.format(new Date()));
        try {
            ((RSSGenerator)this.delegate).addItemToFeedFile(file.toURI().toURL(), nbItems.intValue(), values);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
        String redirect = request.getParameter("from");
        if (redirect != null) {
            response.sendRedirect(redirect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doList(HttpServletResponse response) throws IOException {
        File[] files = ((RSSGenerator)this.delegate).getGeneratorDirectory().listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        response.setContentType("text/xml;charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            if (files.length > 0) {
                String format = "<option value=\"%1$s\">%1$s</option>";
                for (File f : files) {
                    String name = f.getName();
                    out.println(String.format(format, name.substring(0, name.length() - 4)));
                }
            } else {
                out.println("<span class='error'>no feed generated</span>");
            }
        }
    }

    public void doShow(File file, String feedName, HttpServletResponse response) throws ServletException, IOException {
        if (!file.exists()) {
            throw new ServletException("could not find feed " + feedName);
        }
        response.setContentType("text/xml;charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            SyndFeed feed = RSSIOUtil.readFeed((URL)file.toURI().toURL());
            RSSIOUtil.saveFeed((Writer)out, (SyndFeed)feed);
        }
    }

    protected ConfigInitializer<ServletConfig, ?> newConfigInitializer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected RSSGenerator newDelegate() throws Exception {
        return RSSGenerator.newDefaultInstance();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        if ("list".equals(action = action.trim().toLowerCase())) {
            this.doList(response);
            return;
        }
        String feedName = request.getParameter("feedName");
        if (feedName == null || "".equals(feedName)) {
            throw new ServletException("could not find feedName parameter");
        }
        File file = new File(((RSSGenerator)this.delegate).getGeneratorDirectory(), feedName + ".xml");
        if ("show".equals(action)) {
            this.doShow(file, feedName, response);
            return;
        }
        if ("create".equals(action)) {
            this.doCreateFeed(request, response, feedName, file);
            return;
        }
        if ("delete".equals(action)) {
            this.doDeleteFeed(request, response, feedName, file);
            return;
        }
        if ("additem".equals(action)) {
            this.doAddItem(request, response, feedName, file);
            return;
        }
        throw new ServletException("action '" + action + "' is unknown ");
    }

    protected void addFieldValue(Field field, String value, Map<Field, Object> values) {
        if (value != null && !"".equals(value.trim())) {
            values.put(field, value);
        }
    }
}

