package org.nuiton.topia.templates;

/*
 * #%L
 * ToPIA :: Templates
 * $Id: PersistenceContextTransformer.java 2898 2013-11-27 17:13:23Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-6/topia-templates/src/main/java/org/nuiton/topia/templates/PersistenceContextTransformer.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */





import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.AbstractTopiaPersistenceContext;
import org.nuiton.topia.persistence.HibernateProvider;
import org.nuiton.topia.persistence.TopiaHibernateSessionRegistry;
import org.nuiton.topia.TopiaListenableSupport;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

import java.util.List;

/**
 * To generate PersistenceHelper
 *
 * @author tchemit <chemit@codelutin.com>
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.templates.PersistenceContextTransformer"
 * @since 3.0
 */
public class PersistenceContextTransformer extends ObjectModelTransformerToJava {

    @Override
    public void transformFromModel(ObjectModel input) {

        String packageName = TopiaGeneratorUtil.getPersistenceContextPackage(this, model);

        String entityAbstractName = TopiaGeneratorUtil.getPersistenceContextAbstractName(model);

        String entityConcreteName = TopiaGeneratorUtil.getPersistenceContextConcreteName(model);

        boolean generateAbstract = !isInClassPath(packageName, entityAbstractName);

        boolean generateConcrete = !isInClassPath(packageName, entityConcreteName);


        if (generateAbstract) {

            generateAbstract(packageName,
                             entityAbstractName);
        }

        if (generateConcrete) {

            generateImpl(packageName,
                         entityAbstractName,
                         entityConcreteName);
        }

    }

    protected void generateAbstract(String packageName,
                                    String className) {

        // try to find a super class by tag-value
//        String superClass = TopiaGeneratorUtil.getPersistenceContextSuperClassTagValue(model);
        String superClass = null;

        if (superClass == null) {

            // no super-class, use default one
            superClass = AbstractTopiaPersistenceContext.class.getName();
        }

        ObjectModelClass output = createAbstractClass(className, packageName);

        setSuperClass(output, superClass);

        // detect if there is a contract to set on abstract
        String contractName = TopiaGeneratorUtil.getPersistenceContextInterfaceName(model);

//        addInterface(output, TopiaPersistenceContext.class);

        boolean addPersistenceContextContract = isInClassPath(packageName, contractName);

        if (addPersistenceContextContract) {
            addInterface(output, packageName + "." + contractName);
        }

        String modelName = model.getName();
        String daoHelperClazzName = modelName + "DAOHelper";

        String entityEnumName = TopiaGeneratorUtil.getEntityEnumName(model);

        List<ObjectModelClass> entityClasses =
                TopiaGeneratorUtil.getEntityClasses(model, true);

        boolean generateOperator =
                TopiaGeneratorUtil.shouldGenerateOperatorForDAOHelper(model);

//        boolean generateStandaloneEnum =
//                TopiaGeneratorUtil.shouldGenerateStandaloneEnumForDAOHelper(model);

//        if (!generateStandaloneEnum) {
//
//            addImport(output, packageName + "." + entityEnumName);
//
//        }

        addImport(output, TopiaEntity.class);

        if (generateOperator) {
            addImport(output, EntityOperator.class);
//            addImport(output, EntityOperatorStore.class);
        }

        // add public constructor
        ObjectModelOperation constructor = addConstructor(
                output,
                ObjectModelJavaModifier.PUBLIC);
        addParameter(constructor, HibernateProvider.class, "hibernateProvider");
        addParameter(constructor, TopiaListenableSupport.class, "listenableSupport");
        addParameter(constructor, TopiaIdFactory.class, "topiaIdFactory");
        addParameter(constructor, TopiaHibernateSessionRegistry.class, "sessionRegistry");
        setOperationBody(constructor, ""
+"\n"
+"        super(hibernateProvider, listenableSupport, topiaIdFactory, sessionRegistry);\n"
+"    "
        );

        ObjectModelOperation op;

        // getModelVersion method
        String modelVersion = model.getVersion();
        op = addOperation(output, "getModelVersion", "String", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        setOperationBody(op, ""
+"\n"
+"        return \""+modelVersion+"\";\n"
+"    "
        );

        // getModelName method
        op = addOperation(output, "getModelName", "String", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        setOperationBody(op, ""
+"\n"
+"        return \""+modelName+"\";\n"
+"    "
        );

        for (ObjectModelClass clazz : entityClasses) {
            String clazzName = clazz.getName();

            // TODO brendan 14/10/13 use method
            String daoContractName = clazzName + "Dao";
            String daoClazzName = TopiaGeneratorUtil.getConcreteDaoName(clazz);

            // specialized getXXXDao method
            op = addOperation(output, "get" + daoContractName, clazz.getPackageName() + '.' + daoClazzName);
            addImport(output, clazz);
            setOperationBody(op, ""
+"\n"
+"        "+daoClazzName+" result = getDao("+clazzName+".class, "+daoClazzName+".class);\n"
+"        return result;\n"
+"    "
            );

        }

        // getContracts method
        op = addOperation(output, "getContracts", entityEnumName + "[]", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getContracts();\n"
+"    "
        );

        // getContractClass method
        op = addOperation(output, "getContractClass", "<T extends TopiaEntity> Class<T>", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getContractClass(klass);\n"
+"    "
        );

        // getContractClasses method
        op = addOperation(output, "getContractClasses", "Class<? extends TopiaEntity>[]", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getContractClasses();\n"
+"    "
        );

        // getImplementationClass method
        op = addOperation(output, "getImplementationClass", "<T extends TopiaEntity> Class<T>", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getImplementationClass(klass);\n"
+"    "
        );

        // getImplementationClasses method
        op = addOperation(output, "getImplementationClasses", "Class<? extends TopiaEntity>[]", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getImplementationClasses();\n"
+"    "
        );

        // getImplementationClassesAsString method
        op = addOperation(output, "getImplementationClassesAsString", "String", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getImplementationClassesAsString();\n"
+"    "
        );

        if (generateOperator) {
            // getOperator method
            op = addOperation(output, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC);
            addParameter(op, "Class<T>", "klass");
            setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getOperator(klass);\n"
+"    "
            );
        }

    }

    protected ObjectModelClass generateImpl(String packageName,
                                            String entityAbstractName,
                                            String entityConcreteName) {

        ObjectModelClass output = createClass(entityConcreteName, packageName);

        setSuperClass(output, entityAbstractName);

        ObjectModelOperation constructor = addConstructor(
                output,
                ObjectModelJavaModifier.PUBLIC);
        addParameter(constructor, HibernateProvider.class, "hibernateProvider");
        addParameter(constructor, TopiaListenableSupport.class, "listenableSupport");
        addParameter(constructor, TopiaIdFactory.class, "topiaIdFactory");
        addParameter(constructor, TopiaHibernateSessionRegistry.class, "sessionRegistry");
        setOperationBody(constructor, ""
+"\n"
+"        super(hibernateProvider, listenableSupport, topiaIdFactory, sessionRegistry);\n"
+"    "
        );

        return output;
    }

}
