/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.clients;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaProxy;

public class XMLRPCProxy
implements TopiaProxy {
    private static final Log logger = LogFactory.getLog(XMLRPCProxy.class);
    protected String serviceLocation = null;
    protected Class<? extends TopiaApplicationService> clazz;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        logger.debug((Object)("Invoke : " + this.clazz.getName() + "." + method.getName() + "(" + Arrays.toString(args) + ")"));
        logger.debug((Object)("XML-RPC , Using uri = http:" + this.serviceLocation));
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        try {
            config.setServerURL(new URL("http:" + this.serviceLocation));
            XmlRpcClient client = new XmlRpcClient();
            client.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(client));
            client.setConfig((XmlRpcClientConfig)config);
            result = client.execute(this.clazz.getName() + "." + method.getName(), args);
        }
        catch (MalformedURLException e) {
            System.out.println("Caught MalformedURLException\n");
            e.printStackTrace();
        }
        catch (XmlRpcException e) {
            System.out.println("Caught XmlRpcException\n");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void setURI(URI uri) {
        this.serviceLocation = uri.getRawSchemeSpecificPart();
    }

    @Override
    public void setClass(Class<? extends TopiaApplicationService> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(TopiaContext context) {
    }
}

