package org.nuiton.topia.taas.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public  abstract class TaasUserDAOAbstract<E extends TaasUser> extends TopiaDAOImpl<E> implements TopiaDAO<E> {


     /**
      * getEntityClass :
      * @return Class<E> 
      */
    public Class<E> getEntityClass() {
        return (Class<E>)TaasUser.class;
    }

     /**
      * delete :
      * @param entity 
      * @throws TopiaException
      */
    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

     /**
      * findByLogin :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut login le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByLogin(String v) throws TopiaException {
        E result = findByProperty(TaasUser.LOGIN, v);
        return result;
    }

     /**
      * findAllByLogin :
      * Retourne les éléments ayant comme valeur pour l'attribut login le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByLogin(String v) throws TopiaException {
        List<E> result = findAllByProperty(TaasUser.LOGIN, v);
        return result;
    }

     /**
      * findByPassword :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut password le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByPassword(String v) throws TopiaException {
        E result = findByProperty(TaasUser.PASSWORD, v);
        return result;
    }

     /**
      * findAllByPassword :
      * Retourne les éléments ayant comme valeur pour l'attribut password le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByPassword(String v) throws TopiaException {
        List<E> result = findAllByProperty(TaasUser.PASSWORD, v);
        return result;
    }

     /**
      * findByEmail :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut email le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByEmail(String v) throws TopiaException {
        E result = findByProperty(TaasUser.EMAIL, v);
        return result;
    }

     /**
      * findAllByEmail :
      * Retourne les éléments ayant comme valeur pour l'attribut email le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByEmail(String v) throws TopiaException {
        List<E> result = findAllByProperty(TaasUser.EMAIL, v);
        return result;
    }

     /**
      * findByEnabled :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut enabled le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByEnabled(boolean v) throws TopiaException {
        E result = findByProperty(TaasUser.ENABLED, v);
        return result;
    }

     /**
      * findAllByEnabled :
      * Retourne les éléments ayant comme valeur pour l'attribut enabled le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByEnabled(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(TaasUser.ENABLED, v);
        return result;
    }

     /**
      * findByLastConnectionDate :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut lastConnectionDate le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByLastConnectionDate(Date v) throws TopiaException {
        E result = findByProperty(TaasUser.LAST_CONNECTION_DATE, v);
        return result;
    }

     /**
      * findAllByLastConnectionDate :
      * Retourne les éléments ayant comme valeur pour l'attribut lastConnectionDate le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByLastConnectionDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(TaasUser.LAST_CONNECTION_DATE, v);
        return result;
    }

     /**
      * findByNumberOfConnection :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut numberOfConnection le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByNumberOfConnection(int v) throws TopiaException {
        E result = findByProperty(TaasUser.NUMBER_OF_CONNECTION, v);
        return result;
    }

     /**
      * findAllByNumberOfConnection :
      * Retourne les éléments ayant comme valeur pour l'attribut numberOfConnection le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByNumberOfConnection(int v) throws TopiaException {
        List<E> result = findAllByProperty(TaasUser.NUMBER_OF_CONNECTION, v);
        return result;
    }

     /**
      * findByLink :
      * Retourne le premier élément trouvé ayant comme valeur pour l'attribut link le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findByLink(String v) throws TopiaException {
        E result = findByProperty(TaasUser.LINK, v);
        return result;
    }

     /**
      * findAllByLink :
      * Retourne les éléments ayant comme valeur pour l'attribut link le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllByLink(String v) throws TopiaException {
        List<E> result = findAllByProperty(TaasUser.LINK, v);
        return result;
    }

     /**
      * findContainsPrincipals :
      * Retourne le premier élément ayant comme valeur pour l'attribut principals le paramètre.
      * @param v 
      * @return E 
      * @throws TopiaException
      */
    public E findContainsPrincipals(TaasPrincipal v) throws TopiaException {
        E result = findContains(TaasUser.PRINCIPALS, v);
        return result;
    }

     /**
      * findAllContainsPrincipals :
      * Retourne les éléments ayant comme valeur pour l'attribut principals le paramètre.
      * @param v 
      * @return List<E> 
      * @throws TopiaException
      */
    public List<E> findAllContainsPrincipals(TaasPrincipal v) throws TopiaException {
        List<E> result = findAllContains(TaasUser.PRINCIPALS, v);
        return result;
    }

     /**
      * findUsages :
      * @param type 
      * @param entity 
      * @return <U extends TopiaEntity> List<U> 
      * @throws TopiaException
      */

    @Override    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

     /**
      * findAllUsages :
      * @param entity 
      * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
      * @throws TopiaException
      */

    @Override    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //TaasUserDAOAbstract<E extends TaasUser>
