package org.nuiton.topia.security.entities.authorization;

import java.util.Set;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.security.listener.NoSecurityLoad;

@SearchFields ()

public interface TopiaAuthorization extends NoSecurityLoad, TopiaEntity {    /**
     * getExpression :
     * @return String 
     */

     String getExpression();

    /**
     * getActions :
     * @return int 
     */

     int getActions();

    /**
     * getPrincipals :
     * @return Set 
     */

     Set getPrincipals();

    /**
     * implies :
     * @param authorization 
     * @return boolean 
     */

     boolean implies(TopiaAuthorization authorization);

    /**
     * impliesExpression :
     * @param thisExpression 
     * @param thatExpression 
     * @return boolean 
     */

     boolean impliesExpression(String thisExpression, String thatExpression);

    /**
     * impliesActions :
     * @param thisActions 
     * @param thatActions 
     * @return boolean 
     */

     boolean impliesActions(int thisActions, int thatActions);

    /**
     * impliesPrincipals :
     * @param thisPrincipals 
     * @param thatPrincipals 
     * @return boolean 
     */

     boolean impliesPrincipals(Set thisPrincipals, Set thatPrincipals);


} //TopiaAuthorization
