package org.nuiton.topia.taas.entities;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"name"}
)        
public interface TaasPrincipal extends TopiaEntity {

    public static final String NAME = "name";

    public static final String AUTHORIZATIONS = "authorizations";

    /**
     * @param name La valeur de l'attribut name à positionner.
     */
    public void setName(java.lang.String name);

    /**
     * @return La valeur de l'attribut name.
     */
    public java.lang.String getName();

    /**
     * @param authorizations L'instance de authorizations à ajouter.
     */
    public void addAuthorizations(org.nuiton.topia.taas.entities.TaasAuthorization authorizations);

    /**
     * @param authorizations Les instances de authorizations à ajouter.
     */
    public void addAllAuthorizations(java.util.Collection<org.nuiton.topia.taas.entities.TaasAuthorization> authorizations);

    /**
     * @param authorizations La Collection de authorizations à positionner.
     */
    public void setAuthorizations(java.util.Collection<org.nuiton.topia.taas.entities.TaasAuthorization> authorizations);

    /**
     * @param authorizations L'instance de authorizations à retirer.
     */
    public void removeAuthorizations(org.nuiton.topia.taas.entities.TaasAuthorization authorizations);

    /**
     * Vide la Collection de authorizations.
     */
    public void clearAuthorizations();

    /**
     * @return La Liste de authorizations.
     */
    public java.util.Collection<org.nuiton.topia.taas.entities.TaasAuthorization> getAuthorizations();


    /**
     * Recupère l'attribut authorizations à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.nuiton.topia.taas.entities.TaasAuthorization getAuthorizationsByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection authorizations.
     */
    public int sizeAuthorizations();

    /**
     * @return <code>true</code> si la collection authorizations est vide.
     */
    public boolean isAuthorizationsEmpty();

} //TaasPrincipal
