/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.topia.it.legacy.TopiaItLegacyEntityEnum;
import org.nuiton.topia.it.legacy.TopiaItLegacyTopiaApplicationContext;
import org.nuiton.topia.it.legacy.TopiaItLegacyTopiaPersistenceContext;
import org.nuiton.topia.it.legacy.test.entities.Person;
import org.nuiton.topia.it.legacy.test.entities.PersonImpl;
import org.nuiton.topia.it.legacy.test.entities.Pet;
import org.nuiton.topia.it.legacy.test.entities.PetImpl;
import org.nuiton.topia.it.legacy.test.entities.Race;
import org.nuiton.topia.it.legacy.test.entities.RaceImpl;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.replication.AbstractTopiaReplicationServiceTest;
import org.nuiton.topia.replication.TopiaReplicationServiceImplTest;

public class TopiaReplicationServiceImplAllTest
extends AbstractTopiaReplicationServiceTest {
    private static final Log log = LogFactory.getLog(TopiaReplicationServiceImplTest.class);
    protected static final TopiaEntityEnum[] contracts = new TopiaEntityEnum[]{TopiaItLegacyEntityEnum.Person, TopiaItLegacyEntityEnum.Pet, TopiaItLegacyEntityEnum.Race};
    protected static final String entitiesList = PersonImpl.class.getName() + "," + PetImpl.class.getName() + "," + RaceImpl.class.getName();
    protected static Person person;
    protected static Person person2;
    protected static Pet pet;
    protected static Pet pet2;
    protected static Pet pet3;
    protected static Race race;
    protected static Race race2;
    protected static Race race3;

    @AfterClass
    public static void after() throws Exception {
        AbstractTopiaReplicationServiceTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        person = this.update(person);
        person2 = this.update(person2);
        pet = this.update(pet);
        pet2 = this.update(pet2);
        race = this.update(race);
        race2 = this.update(race2);
        race3 = this.update(race3);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.destinationContext != null && !this.destinationContext.isClosed()) {
            this.destinationContext.close();
        }
    }

    @Override
    @Test
    public void testDetectTypes() throws Exception {
        this.detectTypes((TopiaEntity)race, Race.class);
        this.detectTypes((TopiaEntity)pet, Pet.class, Person.class, Race.class);
        this.detectTypes((TopiaEntity)person, Pet.class, Person.class, Race.class);
        this.detectTypes((TopiaEntity)pet2, Pet.class);
        this.detectTypes((TopiaEntity)person2, Person.class);
        this.detectTypes((TopiaEntity)race2, Race.class);
        this.detectTypes((TopiaEntity)race3, Race.class);
        this.detectTypes((TopiaEntity)pet3, Pet.class, Race.class);
    }

    @Override
    @Test
    public void testGetOperation() throws Exception {
    }

    @Override
    @Test
    public void testDetectAssociations() throws Exception {
        this.detectAssociations((TopiaEntity)person, TopiaItLegacyEntityEnum.Person, "pet");
        this.detectAssociations((TopiaEntity)race, new Object[0]);
        this.detectAssociations((TopiaEntity)pet, new Object[0]);
        this.detectAssociations((TopiaEntity)person2, new Object[0]);
        this.detectAssociations((TopiaEntity)race2, new Object[0]);
        this.detectAssociations((TopiaEntity)pet2, new Object[0]);
    }

    @Override
    @Test
    public void testDetectDirectDependencies() throws Exception {
        this.detectDirectDependencies((TopiaEntity)person, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)race, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)pet, TopiaItLegacyEntityEnum.Pet, "person", TopiaItLegacyEntityEnum.Pet, "race");
        this.detectDirectDependencies((TopiaEntity)person2, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)race2, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)pet2, new Object[0]);
    }

    @Override
    @Test
    public void testDetectShell() throws Exception {
        this.detectShell((TopiaEntity)person, new TopiaEntityEnum[]{TopiaItLegacyEntityEnum.Pet, TopiaItLegacyEntityEnum.Race});
        this.detectShell((TopiaEntity)race, new TopiaEntityEnum[0]);
        this.detectShell((TopiaEntity)pet, new TopiaEntityEnum[]{TopiaItLegacyEntityEnum.Person, TopiaItLegacyEntityEnum.Race});
        this.detectShell((TopiaEntity)person2, new TopiaEntityEnum[]{TopiaItLegacyEntityEnum.Pet, TopiaItLegacyEntityEnum.Race});
        this.detectShell((TopiaEntity)race2, new TopiaEntityEnum[0]);
        this.detectShell((TopiaEntity)pet2, new TopiaEntityEnum[]{TopiaItLegacyEntityEnum.Person, TopiaItLegacyEntityEnum.Race});
    }

    @Override
    @Test
    public void testDetectDependencies() throws Exception {
        this.detectDependencies(null, new TopiaEntityEnum[][]{{TopiaItLegacyEntityEnum.Race}, {TopiaItLegacyEntityEnum.Person}, {TopiaItLegacyEntityEnum.Pet}});
    }

    @Override
    @Test
    public void testDetectObjectsToDettach() throws Exception {
        this.detectObjectsToDettach(null, TopiaItLegacyEntityEnum.Person, new String[]{"pet"});
    }

    @Override
    @Test
    public void testDetectOperations() throws Exception {
        this.detectOperations(null, new Object[0]);
    }

    @Override
    @Test
    public void testDoReplicate() throws Exception {
        this.doReplicateAll();
    }

    @Override
    protected TopiaApplicationContext createDb(String name) throws Exception {
        TopiaItLegacyTopiaApplicationContext sourceContext = this.newTopiaItLegacyTopiaApplicationContext(name);
        TopiaItLegacyTopiaPersistenceContext tx = sourceContext.newPersistenceContext();
        person = (Person)tx.getDao(Person.class).create("name", (Object)"pudding master", new Object[0]);
        race = (Race)tx.getDao(Race.class).create("name", (Object)"race I", new Object[0]);
        pet = (Pet)tx.getDao(Pet.class).create("name", (Object)"pudding", new Object[]{"person", person, "race", race});
        person2 = (Person)tx.getDao(Person.class).create("name", (Object)"pudding II master", new Object[0]);
        pet2 = (Pet)tx.getDao(Pet.class).create("name", (Object)"pudding II", new Object[0]);
        race2 = (Race)tx.getDao(Race.class).create("name", (Object)"race II", new Object[0]);
        race3 = (Race)tx.getDao(Race.class).create("name", (Object)"race III", new Object[0]);
        pet3 = (Pet)tx.getDao(Pet.class).create("name", (Object)"pudding III", new Object[]{"race", race3});
        tx.commit();
        tx.close();
        return sourceContext;
    }

    @Override
    protected TopiaEntityEnum[] getContracts() {
        return contracts;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected void createModel(TopiaEntity entity) throws TopiaException {
        this.model = this.getModelBuilder().createModelForAll(this.getContracts());
    }

    @Override
    protected void prepareModel(String ... ids) throws TopiaException {
        this.model = this.service.prepareForAll(this.getContracts());
    }
}

