/*
 * #%L
 * ToPIA :: Service Replication
 * 
 * $Id: Link.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4.1/topia-service-replication/src/main/java/org/nuiton/topia/replication/model/Link.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.replication.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * Pour definir un lien entre deux entites (deux noeuds de replication).
 *
 * @author chemit
 */
public class Link {

    protected final ReplicationNode source;
    protected final Set<ReplicationNode> requires;
    protected final ReplicationNode target;
    protected final String name;
    protected final boolean association;

    public Link(ReplicationNode source, ReplicationNode target, String name, boolean association) {
        this.source = source;
        this.target = target;
        this.name = name;
        this.association = association;
        Set<ReplicationNode> tmpSet = new HashSet<ReplicationNode>();
        tmpSet.add(source);
        tmpSet.addAll(source.getAssociations().values());
        tmpSet.addAll(source.getDependencies().values());
        tmpSet.remove(target);
        requires = Collections.unmodifiableSet(tmpSet);
    }

    public String getName() {
        return name;
    }

    public ReplicationNode getSource() {
        return source;
    }

    public ReplicationNode getTarget() {
        return target;
    }

    public boolean isAssociation() {
        return association;
    }

    /**
     * Teste si on peut reattacher le lien en connaissant l'univers des
     * noeuds disponibles.
     *
     * On teste si toutes les pre-requis sont disponibles.
     * 
     * Si oui, on peut reattacher.
     *
     * @param universe l'univers des noeuds disponibles
     * @param currentNode le noeud qui vient d'etre replique
     * @return <code>true</code> si on peut reattacher ce lien
     */
    public boolean canReattach(Set<ReplicationNode> universe, ReplicationNode currentNode) {
        boolean result = universe.containsAll(requires);
        if (result) {
            result = currentNode.equals(target) || universe.contains(target);
        }
        return result;
    }

    @Override
    public String toString() {
        return "<source:" + source + ", target:" + target + ", name:" + name + ", association:" + association + ">";
    }
}
