package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.history.entities.History;
import org.nuiton.topia.history.entities.HistoryDAO;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class TopiaHistoryDAOHelper {

    /**
     * no instance for this helper
     */
    protected TopiaHistoryDAOHelper() {
    }

    public static HistoryDAO getHistoryDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        HistoryDAO result = (HistoryDAO) ci.getDAO(History.class);
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getContractClasses() {
        TopiaHistoryEntityEnum[] values = TopiaHistoryEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        TopiaHistoryEntityEnum[] values = TopiaHistoryEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static TopiaHistoryEntityEnum[] getContracts() {
        return TopiaHistoryEntityEnum.values();
    }
 
    /*
     * Enumeration of all types of entities managed by this helper.
     */
    public enum TopiaHistoryEntityEnum implements org.nuiton.topia.persistence.TopiaEntityEnum {

        History(History.class);

        /** the contract of the entity */
        private Class<? extends TopiaEntity> contract;

        /** the fully qualified name of the implementation of the entity */
        private String implementationFQN;

        /** the implementation class of the entity (will be lazy computed at runtime)*/
        private Class<? extends TopiaEntity> implementation;

        TopiaHistoryEntityEnum(Class<? extends TopiaEntity > contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName()+"Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract() {
            return contract;
        }
       
        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return getContract();
        }
        
        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return getImplementation();
        }

        @Override
        public String getImplementationFQN() {
            return implementationFQN;
        }

        @Override
        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
         }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass) {
            return TopiaHistoryDAOHelper.getContractClass(klass) == contract;
        }
 
        @Override
        @SuppressWarnings({"unchecked"})
        public Class<? extends TopiaEntity> getImplementation() {
            if (implementation == null) {
                try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
            }
            return implementation;
        }

        public static TopiaHistoryEntityEnum valueOf(TopiaEntity entity) {
            return valueOf(entity.getClass());
        }

        public static TopiaHistoryEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return TopiaHistoryEntityEnum.valueOf(klass.getSimpleName());
            }
            for (TopiaHistoryEntityEnum entityEnum : TopiaHistoryEntityEnum.values()) {
                if (entityEnum.getContract().isAssignableFrom(klass)) {
                    //todo check it works for inheritance
                    return entityEnum;
                }
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(TopiaHistoryEntityEnum.values()));
        }        
    }

    /**
     * use {@link #getImplementationClassesAsString()}
     *
     * @deprecated (will be removed soon).
     */
    public static final String entitiesList = "" +
        "org.nuiton.topia.history.entities.HistoryImpl";

} //TopiaHistoryDAOHelper
