/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.loader.MultipleBagFetchException;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryException;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;

public class HibernateTopiaJpaSupport
implements TopiaJpaSupport {
    private static final Log log = LogFactory.getLog(HibernateTopiaJpaSupport.class);
    protected TopiaHibernateSupport hibernateSupport;
    protected TopiaFiresSupport firesSupport;
    protected boolean useFlushMode = true;

    public HibernateTopiaJpaSupport(TopiaHibernateSupport hibernateSupport, TopiaFiresSupport firesSupport) {
        this.hibernateSupport = hibernateSupport;
        this.firesSupport = firesSupport;
    }

    public TopiaHibernateSupport getHibernateSupport() {
        return this.hibernateSupport;
    }

    @Override
    public void setUseFlushMode(boolean useFlushMode) {
        this.useFlushMode = useFlushMode;
    }

    protected Query prepareQuery(String jpaql, Map<String, Object> parameters) {
        this.checkHqlParameters(parameters);
        Query query = this.hibernateSupport.getHibernateSession().createQuery(jpaql);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value.getClass().isArray()) {
                query.setParameterList(name, (Object[])value);
                continue;
            }
            if (value instanceof Collection) {
                query.setParameterList(name, (Collection)value);
                continue;
            }
            query.setParameter(name, value);
        }
        if (this.useFlushMode) {
            query.setFlushMode(FlushMode.AUTO);
        }
        return query;
    }

    protected void checkHqlParameters(Map<String, Object> parameters) {
        Preconditions.checkArgument((!parameters.containsKey("object") ? 1 : 0) != 0, (Object)"'object' is not a valid parameter name in HQL");
    }

    @Override
    public <T> List<T> findAll(String jpaql, Map<String, Object> parameters) {
        try {
            Query query = this.prepareQuery(jpaql, parameters);
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (MultipleBagFetchException mbfe) {
            throw new TopiaQueryException("unable to fetch multiple bags during findAll: " + mbfe.getBagRoles(), (Throwable)mbfe, jpaql, parameters);
        }
        catch (HibernateException he) {
            throw new TopiaQueryException("unable to findAll", (Throwable)he, jpaql, parameters);
        }
        catch (RuntimeException re) {
            throw new TopiaQueryException("unable to findAll", (Throwable)re, jpaql, parameters);
        }
    }

    @Override
    public <T> T findUnique(String jpaql, Map<String, Object> parameters) {
        List<T> results = this.find(jpaql, 0, 1, parameters);
        if (results.size() > 1) {
            String message = String.format("Query '%s' returns more than 1 unique result", jpaql);
            throw new TopiaException(message);
        }
        T result = null;
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

    @Override
    public <T> List<T> find(String jpaql, int startIndex, int endIndex, Map<String, Object> parameters) {
        try {
            Query query = this.prepareQuery(jpaql, parameters);
            query.setFirstResult(startIndex);
            query.setMaxResults(endIndex - startIndex + 1);
            List result = query.list();
            result = this.firesSupport.fireEntitiesLoad(this, result);
            return result;
        }
        catch (MultipleBagFetchException mbfe) {
            throw new TopiaQueryException("unable to fetch multiple bags during find page startIndex=" + startIndex + ", endIndex=" + endIndex + ": " + mbfe.getBagRoles(), (Throwable)mbfe, jpaql, parameters);
        }
        catch (HibernateException e) {
            throw new TopiaQueryException("unable to find page startIndex=" + startIndex + ", endIndex=" + endIndex, (Throwable)e, jpaql, parameters);
        }
        catch (RuntimeException e) {
            throw new TopiaQueryException("unable to find page startIndex=" + startIndex + ", endIndex=" + endIndex, (Throwable)e, jpaql, parameters);
        }
    }

    @Override
    public int execute(String jpaql, Map<String, Object> parameters) {
        try {
            Query query = this.prepareQuery(jpaql, parameters);
            int result = query.executeUpdate();
            return result;
        }
        catch (MultipleBagFetchException mbfe) {
            throw new TopiaQueryException("unable to fetch multiple bags during execute: " + mbfe.getBagRoles(), (Throwable)mbfe, jpaql, parameters);
        }
        catch (HibernateException e) {
            throw new TopiaQueryException("unable to execute query", (Throwable)e, jpaql, parameters);
        }
        catch (RuntimeException e) {
            throw new TopiaQueryException("unable to execute query", (Throwable)e, jpaql, parameters);
        }
    }

    @Override
    public void save(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().save(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'save' instance", eee);
        }
    }

    @Override
    public void update(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().update(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'update' instance", eee);
        }
    }

    @Override
    public void saveOrUpdate(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().saveOrUpdate(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'saveOrUpdate' instance", eee);
        }
    }

    @Override
    public void delete(Object object) {
        try {
            this.hibernateSupport.getHibernateSession().delete(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'delete' instance", eee);
        }
    }
}

