/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.lang.reflect.Array;
import java.util.List;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.AbstractTopiaPersistenceContext;
import org.nuiton.topia.HibernateProvider;
import org.nuiton.topia.TopiaListenableSupport;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

public class PersistenceContextTransformer
extends ObjectModelTransformerToJava {
    public void transformFromModel(ObjectModel input) {
        boolean generateConcrete;
        String packageName = TopiaGeneratorUtil.getPersistenceContextPackage(this, (ObjectModel)this.model);
        String entityAbstractName = TopiaGeneratorUtil.getPersistenceContextAbstractName((ObjectModel)this.model);
        String entityConcreteName = TopiaGeneratorUtil.getPersistenceContextConcreteName((ObjectModel)this.model);
        boolean generateAbstract = !this.isInClassPath(packageName, entityAbstractName);
        boolean bl = generateConcrete = !this.isInClassPath(packageName, entityConcreteName);
        if (generateAbstract) {
            this.generateAbstract(packageName, entityAbstractName);
        }
        if (generateConcrete) {
            this.generateImpl(packageName, entityAbstractName, entityConcreteName);
        }
    }

    protected void generateAbstract(String packageName, String className) {
        String superClass = null;
        if (superClass == null) {
            superClass = AbstractTopiaPersistenceContext.class.getName();
        }
        ObjectModelClass output = this.createAbstractClass(className, packageName);
        this.setSuperClass(output, superClass);
        String contractName = TopiaGeneratorUtil.getPersistenceContextInterfaceName((ObjectModel)this.model);
        boolean addPersistenceContextContract = this.isInClassPath(packageName, contractName);
        if (addPersistenceContextContract) {
            this.addInterface((ObjectModelClassifier)output, packageName + "." + contractName);
        }
        String modelName = ((ObjectModel)this.model).getName();
        String daoHelperClazzName = modelName + "DAOHelper";
        String entityEnumName = modelName + "EntityEnum";
        List<ObjectModelClass> entityClasses = TopiaGeneratorUtil.getEntityClasses((ObjectModel)this.model, true);
        boolean generateOperator = TopiaGeneratorUtil.shouldGenerateOperatorForDAOHelper((ObjectModel)this.model);
        boolean generateStandaloneEnum = TopiaGeneratorUtil.shouldGenerateStandaloneEnumForDAOHelper((ObjectModel)this.model);
        if (!generateStandaloneEnum) {
            this.addImport((ObjectModelClassifier)output, packageName + "." + daoHelperClazzName + "." + entityEnumName);
        }
        this.addImport((ObjectModelClassifier)output, TopiaEntity.class);
        this.addImport((ObjectModelClassifier)output, Array.class);
        this.addImport((ObjectModelClassifier)output, Array.class);
        if (generateOperator) {
            this.addImport((ObjectModelClassifier)output, EntityOperator.class);
            this.addImport((ObjectModelClassifier)output, EntityOperatorStore.class);
        }
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        this.addParameter(constructor, HibernateProvider.class, "hibernateProvider");
        this.addParameter(constructor, TopiaListenableSupport.class, "listenableSupport");
        this.addParameter(constructor, TopiaIdFactory.class, "topiaIdFactory");
        this.setOperationBody(constructor, "\n        super(hibernateProvider, listenableSupport, topiaIdFactory);\n    ");
        String modelVersion = ((ObjectModel)this.model).getVersion();
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)output, "getModelVersion", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        return \"" + modelVersion + "\";\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getModelName", "String", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        return \"" + modelName + "\";\n" + "    ");
        for (ObjectModelClass clazz : entityClasses) {
            String clazzName = clazz.getName();
            String daoContractName = clazzName + "Dao";
            String daoClazzName = TopiaGeneratorUtil.getConcreteDaoName(clazz);
            op = this.addOperation((ObjectModelClassifier)output, "get" + daoContractName, clazz.getPackageName() + '.' + daoClazzName, new ObjectModelModifier[0]);
            this.addImport((ObjectModelClassifier)output, clazz);
            this.setOperationBody(op, "\n        " + daoClazzName + " result = getDao(" + clazzName + ".class, " + daoClazzName + ".class);\n" + "        return result;\n" + "    ");
        }
        op = this.addOperation((ObjectModelClassifier)output, "getContractClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return (Class<T>) constant.getContract();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getImplementationClass", "<T extends TopiaEntity> Class<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.addParameter(op, "Class<T>", "klass");
        this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return (Class<T>) constant.getImplementation();\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getContractClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getContract();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getImplementationClasses", "Class<? extends TopiaEntity>[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        " + entityEnumName + "[] values = " + entityEnumName + ".values();\n" + "        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);\n" + "        for (int i = 0; i < values.length; i++) {\n" + "            result[i] = values[i].getImplementation();\n" + "        }\n" + "        return result;\n" + "    ");
        op = this.addOperation((ObjectModelClassifier)output, "getContracts", entityEnumName + "[]", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
        this.setOperationBody(op, "\n        return " + entityEnumName + ".values();\n" + "    ");
        if (generateOperator) {
            op = this.addOperation((ObjectModelClassifier)output, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC, ObjectModelJavaModifier.STATIC});
            this.addParameter(op, "Class<T>", "klass");
            this.setOperationBody(op, "\n        " + entityEnumName + " constant = " + entityEnumName + ".valueOf(klass);\n" + "        return EntityOperatorStore.getOperator(constant);\n" + "    ");
        }
    }

    protected ObjectModelClass generateImpl(String packageName, String entityAbstractName, String entityConcreteName) {
        ObjectModelClass output = this.createClass(entityConcreteName, packageName);
        this.setSuperClass(output, entityAbstractName);
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        this.addParameter(constructor, HibernateProvider.class, "hibernateProvider");
        this.addParameter(constructor, TopiaListenableSupport.class, "listenableSupport");
        this.addParameter(constructor, TopiaIdFactory.class, "topiaIdFactory");
        this.setOperationBody(constructor, "\n        super(hibernateProvider, listenableSupport, topiaIdFactory);\n    ");
        return output;
    }
}

