package org.nuiton.topia;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: HibernateTopiaSqlSupport.java 2841 2013-10-11 16:47:08Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-5/topia-persistence/src/main/java/org/nuiton/topia/HibernateTopiaSqlSupport.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.hibernate.HibernateException;
import org.hibernate.jdbc.Work;

/**
 * @author Arnaud Thimel <thimel@codelutin.com>
 */
public class HibernateTopiaSqlSupport implements TopiaSqlSupport {

    protected TopiaHibernateSupport hibernateSupport;

    public HibernateTopiaSqlSupport(TopiaHibernateSupport hibernateSupport) {
        this.hibernateSupport = hibernateSupport;
    }

    @Override
    public void executeSQL(String sqlScript) {
        SQLWork sqlWork = new SQLWork(sqlScript);
        try {
            hibernateSupport.getHibernateSession().doWork(sqlWork);
        } catch (HibernateException e) {
            throw new TopiaException("Could not execute sql code", e);
        }
    }

    public static class SQLWork implements Work {
        private final String script;

        public SQLWork(String script) {
            this.script = script;
        }

        @Override
        public void execute(Connection connection) throws SQLException {
            PreparedStatement sta = connection.prepareStatement(script);
            try {
                sta.execute();
            } finally {
                sta.close();
            }
        }
    }

}
