package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: LegacyTopiaDao.java 2866 2013-11-08 11:51:51Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-4/topia-persistence/src/main/java/org/nuiton/topia/persistence/LegacyTopiaDao.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.util.PagerBeanUtil;

import java.security.Permission;
import java.util.List;
import java.util.Map;

/**
 * Implements deprecated method from {@link TopiaDAO}, should be deleted.
 */
@Deprecated
public abstract class LegacyTopiaDao<E extends TopiaEntity> implements TopiaDAO<E> {

    @Override
    public E create(Object... propertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        E result = create(properties);
        return result;
    }

    @Deprecated
    public boolean existByTopiaId(String topiaId) {
        return forTopiaIdEquals(topiaId).exists();
    }

    @Deprecated
    public boolean existByProperties(String propertyName, Object propertyValue,
                                     Object... propertyNamesAndValues) {
        return forProperties(propertyName, propertyValue, propertyNamesAndValues).exists();
    }

    @Deprecated
    protected String createSimpleQuery() {
        return newFromClause(null);
    }

    @Deprecated
    public String createSimpleQuery(String alias) {
        return newFromClause(alias);
    }

    protected abstract String newFromClause(String alias);

    @Deprecated
    public E findByTopiaId(String id) {
        return forTopiaIdEquals(id).findUniqueOrNull();
    }

    @Deprecated
    public E findByProperty(String propertyName, Object value) {
        return forProperties(propertyName, value).findAnyOrNull();
    }

    @Override
    @Deprecated
    public <R> R findByQuery(Class<R> type, String hql, Object... propertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        return findAnyOrNull(hql, properties, type);
    }

    @Override
    @Deprecated
    public E findByPrimaryKey(Map<String, Object> keys) {
        return forProperties(keys).findUniqueOrNull();
    }

    @Override
    @Deprecated
    public E findByPrimaryKey(Object... propertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        E byPrimaryKey = findByPrimaryKey(properties);
        return byPrimaryKey;
    }

    @Override
    @Deprecated
    public List<E> findAllWithOrder(String... propertyNames) {
        return newQueryBuilder().setOrderByArguments(propertyNames).findAll();
    }

    @Override
    @Deprecated
    public <R> List<R> findAllByQuery(Class<R> type, String hql, Object... propertyNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        List<R> all = findAll(hql, hqlParameters, type);
        return all;
    }

    @Deprecated
    public E findByProperties(String propertyName, Object value,
                              Object... propertyNamesAndValues) {
        return forProperties(propertyName, value, propertyNamesAndValues).findUniqueOrNull();
    }

    @Deprecated
    public E findByProperties(Map<String, Object> properties) {
        return forProperties(properties).findUniqueOrNull();
    }

    @Deprecated
    public List<E> findAllByProperty(String propertyName, Object value) {
        List<E> all = forProperties(propertyName, value).findAll();
        return all;
    }

    @Deprecated
    public List<E> findAllByProperties(String propertyName, Object value, Object... propertyNamesAndValues) {
        List<E> all = forProperties(propertyName, value, propertyNamesAndValues).findAll();
        return all;
    }

    @Deprecated
    public List<E> findAllByProperties(Map<String, Object> properties) {
        return forProperties(properties).findAll();
    }

    @Deprecated
    public E findContains(String propertyName, Object value) {
        return newQueryBuilder().addContains(propertyName, value).findAny();
    }

    @Deprecated
    public List<E> findAllContains(String propertyName,
                                   Object value) {
        return newQueryBuilder().addContains(propertyName, value).findAll();
    }

    @Deprecated
    public boolean existsByQuery(String hql, Object... propertyNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        boolean exists = exists(hql, hqlParameters);
        return exists;
    }

    @Deprecated
    public long countByQuery(String hql,
                             Object... propertyNamesAndValues) {

        Preconditions.checkNotNull(StringUtils.isNotBlank(hql));
        Preconditions.checkArgument(hql.toUpperCase().trim().startsWith("SELECT COUNT("));
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        long count = findAny(hql, hqlParameters, Long.class);
        return count;
    }

    @Deprecated
    public E findByQuery(String hql,
                         Object... propertyNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        E uniqueOrNull = forHql(hql, hqlParameters).findUniqueOrNull();
        return uniqueOrNull;
    }

    @Deprecated
    public List<E> findAllByQuery(String hql,
                                  Object... propertyNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        List<E> all = forHql(hql, hqlParameters).findAll();
        return all;
    }

    @Deprecated
    public Iterable<E> findAllLazyByQuery(String hql,
                                          Object... propertyNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        Iterable<E> result = findAllLazy(hql, hqlParameters);
        return result;
    }

    @Deprecated
    public <R> Iterable<R> findAllLazyByQuery(Class<R> type,
                                              String hql,
                                              Object... propertyNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        Iterable<R> result = findAllLazy(hql, hqlParameters, type);
        return result;
    }

    @Deprecated
    public Iterable<E> findAllLazyByQuery(int batchSize,
                                          String hql,
                                          Object... propertyNamesAndValues) {
        return findAllLazyByQuery(getEntityClass(), batchSize, hql, propertyNamesAndValues);
    }


    /**
     * @deprecated use {@link #findAllLazy(String, java.util.Map, Class)}
     */
    @Deprecated
    public <R> Iterable<R> findAllLazyByQuery(Class<R> type,
                                              int batchSize,
                                              String hql,
                                              Object... propertyNamesAndValues) {
        setBatchSize(batchSize);
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        Iterable<R> allLazy = findAllLazy(hql, hqlParameters, type);
        return allLazy;
    }

    @Deprecated
    public <R> List<R> findAllByQueryWithBound(Class<R> type,
                                               String hql,
                                               int startIndex,
                                               int endIndex,
                                               Object... propertyNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        List<R> all = findAll(hql, hqlParameters, type, startIndex, endIndex);
        return all;
    }

    @Deprecated
    public List<E> findAllByQueryWithBound(String hql,
                                           int startIndex,
                                           int endIndex,
                                           Object... propertyNamesAndValues) {
        List<E> result = findAllByQueryWithBound(getEntityClass(),
                hql,
                startIndex,
                endIndex,
                propertyNamesAndValues);
        return result;
    }


    @Deprecated
    public <R> List<R> findAllByQueryAndPager(Class<R> type,
                                              String hql,
                                              TopiaPagerBean pager,
                                              Object... propertyNamesAndValues) {
        Preconditions.checkNotNull(pager);
        Preconditions.checkNotNull(hql);

        if (StringUtils.isNotBlank(pager.getSortColumn())) {
            hql += " ORDER BY " + pager.getSortColumn();
            if (!pager.isSortAscendant()) {
                hql += " DESC";
            }
        }
        List<R> result = findAllByQueryWithBound(type, hql,
                (int) pager.getRecordStartIndex(),
                (int) pager.getRecordEndIndex() - 1,
                propertyNamesAndValues);
        return result;
    }

    @Deprecated
    public List<E> findAllByQueryAndPager(String hql,
                                          TopiaPagerBean pager,
                                          Object... propertyNamesAndValues) {

        List<E> result = findAllByQueryAndPager(getEntityClass(),
                hql,
                pager,
                propertyNamesAndValues);
        return result;
    }

    @Deprecated
    public void computeAndAddRecordsToPager(String hql,
                                            TopiaPagerBean pager,
                                            Object... propertyNamesAndValues) {

        long records = countByQuery(hql, propertyNamesAndValues);

        pager.setRecords(records);
        PagerBeanUtil.computeRecordIndexesAndPagesNumber(pager);
    }

    @Override
    public List<Permission> getRequestPermission(String topiaId, int actions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TopiaContextImplementor getContext() {
        throw new UnsupportedOperationException();
    }


    @Override
    public TopiaContext getTopiaContext() {
        throw new UnsupportedOperationException();
    }


    // let's use method written in AbstractTopiaDao

    protected abstract Iterable<E> findAllLazy(String hql, Map<String, Object> hqlParameters);

    protected abstract <R> R findAny(String hql, Map<String, Object> properties, Class<R> type);

    protected abstract <R> R findAnyOrNull(String hql, Map<String, Object> hqlParameters, Class<R> type);

    protected abstract TopiaQueryBuilderRunQueryStep<E> forHql(String hql, Map<String, Object> hqlParameters);

    protected abstract <R> List<R> findAll(String hql, Map<String, Object> hqlParameters, Class<R> type);

    protected abstract <R> Iterable<R> findAllLazy(String hql, Map<String, Object> hqlParameters, Class<R> type);

    protected abstract <R> List<R> findAll(String hql, Map<String, Object> hqlParameters, Class<R> type, int startIndex, int endIndex);

    protected abstract <R> R findUnique(String hql, Map<String, Object> hqlParameters, Class<R> type);

    protected abstract boolean exists(String hql, Map<String, Object> hqlParameters);

    @Override
    @Deprecated
    public <E1> List<E1> findAll(String hql, Object... propertyNamesAndValues) throws TopiaException {
        return (List<E1>) findAllByQuery(hql, propertyNamesAndValues);
    }

    @Override
    @Deprecated
    public <E1> List<E1> find(String hql, int startIndex, int endIndex, Object... propertyNamesAndValues) throws TopiaException {
        return (List<E1>) findAllByQueryWithBound(hql, startIndex, endIndex, propertyNamesAndValues);
    }

    @Override
    @Deprecated
    public <E1> E1 findUnique(String hql, Object... propertyNamesAndValues) throws TopiaException {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(propertyNamesAndValues);
        return (E1) findUnique(hql, hqlParameters, Object.class);
    }

}
