package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaEntities.java 2777 2013-07-20 00:48:20Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-1/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaEntities.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Function;

public class TopiaEntities {

    protected static final Function<TopiaEntity, String> GET_TOPIA_ID = new Function<TopiaEntity, String>() {

        @Override
        public String apply(TopiaEntity input) {
            return input == null ? null : input.getTopiaId();
        }
    };

    /**
     * Function to obtain {@link TopiaEntity#getTopiaId()} from any entity.
     *
     * @since 2.6.12
     */
    // TODO AThimel 20/07/13 Why is this function useful ? Why not use directly the GET_TOPIA_ID Function ?
    public static Function<TopiaEntity, String> getTopiaIdFunction() {
        return GET_TOPIA_ID;
    }

}
