/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class Contact2Abstract extends TopiaEntityAbstract implements Contact2 {

    /**
     * Nom de l'attribut en BD : contactValue
     */
    protected String contactValue;

    /**
     * Nom de l'attribut en BD : type
     */
    protected String type;

    /**
     * Nom de l'attribut en BD : party2
     */
    protected Collection<Party2> party2;

    private static final long serialVersionUID = 7148679594314643812L;

    static {
    
        I18n.n_("topia.test.common.contact2");
        I18n.n_("topia.test.common.contactValue");
        I18n.n_("topia.test.common.type");
        I18n.n_("topia.test.common.party2");
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CONTACT_VALUE, String.class, contactValue);
        visitor.visit(this, PROPERTY_TYPE, String.class, type);
        visitor.visit(this, PROPERTY_PARTY2, Collection.class, Party2.class, party2);
        visitor.end(this);
    }

    @Override
    public void setContactValue(String contactValue) {
        String oldValue = this.contactValue;
        fireOnPreWrite(PROPERTY_CONTACT_VALUE, oldValue, contactValue);
        this.contactValue = contactValue;
        fireOnPostWrite(PROPERTY_CONTACT_VALUE, oldValue, contactValue);
    }

    @Override
    public String getContactValue() {
        fireOnPreRead(PROPERTY_CONTACT_VALUE, contactValue);
        String result = this.contactValue;
        fireOnPostRead(PROPERTY_CONTACT_VALUE, contactValue);
        return result;
    }

    @Override
    public void setType(String type) {
        String oldValue = this.type;
        fireOnPreWrite(PROPERTY_TYPE, oldValue, type);
        this.type = type;
        fireOnPostWrite(PROPERTY_TYPE, oldValue, type);
    }

    @Override
    public String getType() {
        fireOnPreRead(PROPERTY_TYPE, type);
        String result = this.type;
        fireOnPostRead(PROPERTY_TYPE, type);
        return result;
    }

    @Override
    public void addParty2(Party2 party2) {
        fireOnPreWrite(PROPERTY_PARTY2, null, party2);
        if (this.party2 == null) {
            this.party2 = new ArrayList<Party2>();
        }

        if (party2.getContacts() == null) {
            party2.setContacts(new ArrayList<Contact2>());
        }
        party2.getContacts().add(this);

        this.party2.add(party2);
        fireOnPostWrite(PROPERTY_PARTY2, this.party2.size(), null, party2);
    }

    @Override
    public void addAllParty2(Collection<Party2> party2) {
        if (party2 == null) {
            return;
        }
        for (Party2 item : party2) {
            addParty2(item);
        }
    }

    @Override
    public void setParty2(Collection<Party2> party2) {
        // Copy elements to keep data for fire with new reference
        Collection<Party2> oldValue = this.party2 != null ? new ArrayList<Party2>(this.party2) : null;
        fireOnPreWrite(PROPERTY_PARTY2, oldValue, party2);
        this.party2 = party2;
        fireOnPostWrite(PROPERTY_PARTY2, oldValue, party2);
    }

    @Override
    public void removeParty2(Party2 party2) {
        fireOnPreWrite(PROPERTY_PARTY2, party2, null);
        if (this.party2 == null || !this.party2.remove(party2)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        party2.getContacts().remove(this);

        fireOnPostWrite(PROPERTY_PARTY2, this.party2.size() + 1, party2, null);
    }

    @Override
    public void clearParty2() {
        if (this.party2 == null) {
            return;
        }
        for (Party2 item : this.party2) {
            item.getContacts().remove(this);
        }
        Collection<Party2> oldValue = new ArrayList<Party2>(this.party2);
        fireOnPreWrite(PROPERTY_PARTY2, oldValue, this.party2);
        this.party2.clear();
        fireOnPostWrite(PROPERTY_PARTY2, oldValue, this.party2);
    }

    @Override
    public Collection<Party2> getParty2() {
        return party2;
    }

    @Override
    public Party2 getParty2ByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(party2, topiaId);
    }

    @Override
    public int sizeParty2() {
        if (party2 == null) {
            return 0;
        }
        return party2.size();
    }

    @Override
    public boolean isParty2Empty() {
        int size = sizeParty2();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_CONTACT_VALUE, this.contactValue).
            append(PROPERTY_TYPE, this.type).
         toString();
        return result;
    }

} //Contact2Abstract
