/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.deletetest.Party2DAOImpl;

public abstract class PersonneDAOAbstract<E extends Personne> extends Party2DAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Personne.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Personne;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_NAME, v);
        return result;
    }

    public E findContainsOtherNames(String v) throws TopiaException {
        E result = findContains(Personne.PROPERTY_OTHER_NAMES, v);
        return result;
    }

    public List<E> findAllContainsOtherNames(String v) throws TopiaException {
        List<E> result = findAllContains(Personne.PROPERTY_OTHER_NAMES, v);
        return result;
    }

    public E findByGender(Gender v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_GENDER, v);
        return result;
    }

    public List<E> findAllByGender(Gender v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_GENDER, v);
        return result;
    }

    public E findByOtherGender(Gender v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_OTHER_GENDER, v);
        return result;
    }

    public List<E> findAllByOtherGender(Gender v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_OTHER_GENDER, v);
        return result;
    }

    public E findByAddress(Address v) throws TopiaException {
        E result = findByProperty(Personne.PROPERTY_ADDRESS, v);
        return result;
    }

    public List<E> findAllByAddress(Address v) throws TopiaException {
        List<E> result = findAllByProperty(Personne.PROPERTY_ADDRESS, v);
        return result;
    }

    public E findContainsTitle(Title v) throws TopiaException {
        E result = findContains(Personne.PROPERTY_TITLE, v);
        return result;
    }

    public List<E> findAllContainsTitle(Title v) throws TopiaException {
        List<E> result = findAllContains(Personne.PROPERTY_TITLE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //PersonneDAOAbstract<E extends Personne>
